/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.toolbar;

import com.guigarage.sdk.action.Action;
import com.guigarage.sdk.util.MaterialDesignButton;
import java.util.HashMap;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.Transition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.text.Text;
import javafx.util.Duration;

public abstract class BaseToolbar
extends Region {
    private ObjectProperty<Node> leftNode;
    private StringProperty title;
    private ObservableList<Action> actionItems;
    private HBox actionBox;
    protected Text titleText;
    private Map<Action, Node> itemToNode;
    private BooleanProperty large;
    private DoubleProperty headlineOffset;
    private DoubleProperty smallHeight;
    private DoubleProperty largeHeight;
    private Animation toLargeAnimation;
    private Animation toSmallAnimation;
    private PseudoClass largePseudoClass = PseudoClass.getPseudoClass((String)"large");
    private ImageView backgroundImageView;
    private Line bottomLine;

    public BaseToolbar() {
        this.getStyleClass().add((Object)"base-toolbar");
        this.title = new SimpleStringProperty();
        this.actionItems = FXCollections.observableArrayList();
        this.actionBox = new HBox();
        this.actionBox.getStyleClass().add((Object)"action-box");
        this.getChildren().add((Object)this.actionBox);
        this.itemToNode = new HashMap<Action, Node>();
        this.actionItems.addListener(c -> {
            while (c.next()) {
                if (c.wasPermutated() || c.wasUpdated()) continue;
                for (Action removed : c.getRemoved()) {
                    Node child = this.itemToNode.remove(removed);
                    this.actionBox.getChildren().remove((Object)child);
                }
                for (Action added : c.getAddedSubList()) {
                    MaterialDesignButton button = new MaterialDesignButton();
                    button.setText(added.getIcon().getText());
                    button.setOnMouseEntered(e -> {
                        button.setScaleX(1.1);
                        button.setScaleY(1.1);
                    });
                    button.setOnMouseExited(e -> {
                        button.setScaleX(1.0);
                        button.setScaleY(1.0);
                    });
                    button.setOnAction(e -> {
                        if (added.getCallback() != null) {
                            added.getCallback().call();
                        }
                    });
                    Tooltip t = new Tooltip(added.getTooltip());
                    button.setTooltip(t);
                    added.tooltipProperty().bind((ObservableValue)t.textProperty());
                    this.actionBox.getChildren().add((Object)button);
                    this.itemToNode.put(added, (Node)button);
                }
            }
        });
        this.titleText = new Text();
        this.titleText.getStyleClass().add((Object)"text");
        this.titleText.textProperty().bind((ObservableValue)this.title);
        this.getChildren().add((Object)this.titleText);
        this.leftNode = new SimpleObjectProperty();
        this.leftNode.addListener((obs, oldValue, newValue) -> {
            if (oldValue != null) {
                this.getChildren().remove(oldValue);
            }
            if (newValue != null) {
                this.getChildren().add(newValue);
            }
        });
        this.smallHeight = new SimpleDoubleProperty(64.0);
        this.largeHeight = new SimpleDoubleProperty(192.0);
        this.headlineOffset = new SimpleDoubleProperty(0.0);
        this.headlineOffset.bind((ObservableValue)this.prefHeightProperty().subtract((ObservableNumberValue)this.smallHeight));
        this.large = new SimpleBooleanProperty(false);
        this.large.addListener(e -> {
            this.pseudoClassStateChanged(this.largePseudoClass, this.large.get());
            if (this.large.get()) {
                this.setPrefHeight(this.largeHeight.get());
            } else {
                this.setPrefHeight(this.smallHeight.get());
            }
        });
        this.setPrefHeight(this.smallHeight.get());
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.backgroundImageView = new ImageView();
        this.backgroundImageView.getStyleClass().add((Object)"toolbar-background-image-view");
        this.backgroundImageView.setPreserveRatio(true);
        this.backgroundImageView.setSmooth(true);
        this.backgroundImageView.fitWidthProperty().bind((ObservableValue)this.widthProperty());
        this.backgroundImageView.setOpacity(0.0);
        this.getChildren().add((Object)this.backgroundImageView);
        this.bottomLine = new Line();
        this.bottomLine.setStroke((Paint)Color.BLACK);
        this.bottomLine.setStrokeWidth(2.0);
        this.bottomLine.setStartX(0.0);
        this.bottomLine.endXProperty().bind((ObservableValue)this.widthProperty());
        this.bottomLine.startYProperty().bind((ObservableValue)this.heightProperty());
        this.bottomLine.endYProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.bottomLine);
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageView.setImage(image);
    }

    public void setBackgroundImage(String path) {
        this.backgroundImageView.setImage(new Image(path));
    }

    public Image getBackgroundImage() {
        return this.backgroundImageView.getImage();
    }

    public boolean isLarge() {
        return this.large.get();
    }

    private void stopAnimations() {
        if (this.toLargeAnimation != null) {
            this.toLargeAnimation.pause();
        }
        if (this.toSmallAnimation != null) {
            this.toSmallAnimation.pause();
        }
    }

    public void animateToSmallVersion() {
        if (this.isLarge()) {
            this.stopAnimations();
            final double currentHeight = this.getHeight();
            final double resizeTime = 480.0;
            double fadeTime = 300.0;
            FadeTransition fadeTitleOutTransition = new FadeTransition(Duration.millis((double)fadeTime), (Node)this.titleText);
            fadeTitleOutTransition.setFromValue(this.titleText.getOpacity());
            fadeTitleOutTransition.setToValue(0.0);
            FadeTransition fadeTitleInTransition = new FadeTransition(Duration.millis((double)fadeTime), (Node)this.titleText);
            fadeTitleInTransition.setFromValue(0.0);
            fadeTitleInTransition.setToValue(1.0);
            fadeTitleInTransition.setDelay(Duration.millis((double)(fadeTime + resizeTime)));
            Transition resizeAnimation = new Transition(){
                {
                    this.setCycleDuration(Duration.millis((double)resizeTime));
                }

                protected void interpolate(double frac) {
                    BaseToolbar.this.setPrefHeight(currentHeight + (BaseToolbar.this.smallHeight.get() - currentHeight) * frac);
                    BaseToolbar.this.backgroundImageView.setOpacity(1.0 - frac);
                }
            };
            resizeAnimation.setDelay(Duration.millis((double)fadeTime));
            resizeAnimation.setOnFinished(e -> this.large.setValue(Boolean.valueOf(false)));
            this.toSmallAnimation = new ParallelTransition(new Animation[]{fadeTitleOutTransition, resizeAnimation, fadeTitleInTransition});
            this.toSmallAnimation.play();
        }
    }

    public void animateToLargeVersion() {
        if (!this.isLarge()) {
            this.stopAnimations();
            final double currentHeight = this.getHeight();
            final double resizeTime = 480.0;
            double fadeTime = 300.0;
            FadeTransition fadeTitleOutTransition = new FadeTransition(Duration.millis((double)fadeTime), (Node)this.titleText);
            fadeTitleOutTransition.setFromValue(this.titleText.getOpacity());
            fadeTitleOutTransition.setToValue(0.0);
            FadeTransition fadeTitleInTransition = new FadeTransition(Duration.millis((double)fadeTime), (Node)this.titleText);
            fadeTitleInTransition.setFromValue(0.0);
            fadeTitleInTransition.setToValue(1.0);
            fadeTitleInTransition.setDelay(Duration.millis((double)(fadeTime + resizeTime)));
            Transition resizeAnimation = new Transition(){
                {
                    this.setCycleDuration(Duration.millis((double)resizeTime));
                }

                protected void interpolate(double frac) {
                    BaseToolbar.this.setPrefHeight(currentHeight + (BaseToolbar.this.largeHeight.get() - currentHeight) * frac);
                    BaseToolbar.this.backgroundImageView.setOpacity(frac);
                }
            };
            resizeAnimation.setDelay(Duration.millis((double)fadeTime));
            resizeAnimation.setOnFinished(e -> this.large.setValue(Boolean.valueOf(true)));
            this.toLargeAnimation = new ParallelTransition(new Animation[]{fadeTitleOutTransition, resizeAnimation, fadeTitleInTransition});
            this.toLargeAnimation.play();
        }
    }

    public void setLarge(boolean large) {
        this.stopAnimations();
        this.large.set(large);
        if (large) {
            this.backgroundImageView.setOpacity(1.0);
        } else {
            this.backgroundImageView.setOpacity(0.0);
        }
    }

    protected ObjectProperty<Node> leftNodeProperty() {
        return this.leftNode;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.backgroundImageView.toBack();
        this.backgroundImageView.relocate(0.0, 0.0);
        this.backgroundImageView.resize(this.getWidth(), this.getHeight());
        double actionBoxPrefWidth = this.actionBox.prefWidth(-1.0);
        double actionBoxPrefHeight = this.actionBox.prefHeight(-1.0);
        double leftNodePrefHeight = 0.0;
        double leftNodePrefWidth = 0.0;
        if (this.leftNode.get() != null) {
            leftNodePrefHeight = ((Node)this.leftNode.get()).prefHeight(-1.0);
            leftNodePrefWidth = ((Node)this.leftNode.get()).prefWidth(-1.0);
        }
        double titleTextPrefWidth = this.titleText.prefWidth(-1.0);
        double titleTextPrefHeight = this.titleText.prefHeight(-1.0);
        double centerOfLine = Math.max(actionBoxPrefHeight, leftNodePrefHeight);
        centerOfLine = Math.max(centerOfLine, titleTextPrefHeight);
        centerOfLine = centerOfLine / 2.0 + this.getPadding().getTop();
        this.actionBox.resize(actionBoxPrefWidth, actionBoxPrefHeight);
        this.actionBox.relocate(this.getWidth() - this.getPadding().getRight() - actionBoxPrefWidth, centerOfLine - actionBoxPrefHeight / 2.0);
        if (this.leftNode.get() != null) {
            ((Node)this.leftNode.get()).resize(((Node)this.leftNode.get()).prefWidth(-1.0), leftNodePrefHeight);
            ((Node)this.leftNode.get()).relocate(this.getPadding().getLeft(), centerOfLine - leftNodePrefHeight / 2.0);
        }
        this.titleText.resize(titleTextPrefWidth, titleTextPrefHeight);
        if (this.isLarge()) {
            this.titleText.relocate(this.getPadding().getLeft() + leftNodePrefWidth + 24.0, centerOfLine - titleTextPrefHeight / 2.0 + this.headlineOffset.get());
        } else {
            this.titleText.relocate((this.getWidth() - titleTextPrefWidth) / 2.0, centerOfLine - titleTextPrefHeight / 2.0 + this.headlineOffset.get());
        }
    }

    public double getLargeHeight() {
        return this.largeHeight.get();
    }

    public DoubleProperty largeHeightProperty() {
        return this.largeHeight;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public void addAction(Action action) {
        this.actionItems.add((Object)action);
    }
}

