/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.table;

import com.guigarage.sdk.util.Media;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ImageTableCell<T extends Media>
extends TableCell<T, Image> {
    private ImageView imageView = new ImageView();

    public ImageTableCell() {
        this.setGraphic((Node)this.imageView);
        this.imageView.setPreserveRatio(true);
        DoubleBinding widthBinding = Bindings.createDoubleBinding(() -> this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight(), (Observable[])new Observable[]{this.widthProperty(), this.insetsProperty()});
        this.imageView.fitWidthProperty().bind((ObservableValue)widthBinding);
        this.getStyleClass().addAll((Object[])new String[]{"media-table-cell"});
    }

    protected void updateItem(Image item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.imageView.setImage(item);
    }
}

