/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.overlay;

import com.guigarage.sdk.action.Action;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.shape.Line;
import javafx.util.Duration;

public class Overlay
extends Region {
    private List<Action> actions;
    private Label titleLabel;
    private Label descriptionLabel;
    private Line seperator;
    private Animation showAnimation;
    private Animation hideAnimation;
    private BooleanProperty hidden;

    public Overlay() {
        this.getStyleClass().add((Object)"overlay");
        this.titleLabel = new Label("Beschreibung");
        this.titleLabel.getStyleClass().addAll((Object[])new String[]{"overlay-content", "overlay-title"});
        this.descriptionLabel = new Label("Ich bin die Beschreibung des aktuell angezeigten Datensatzes. Ich kann schon mal l\u00e4nger sein als so ein langweiliger Titel. Daher muss ich nat\u00fcrlich vern\u00fcnftig umbrechen.");
        this.descriptionLabel.getStyleClass().addAll((Object[])new String[]{"overlay-content", "overlay-description"});
        this.descriptionLabel.setWrapText(true);
        this.seperator = new Line();
        this.seperator.getStyleClass().addAll((Object[])new String[]{"overlay-content", "overlay-seperator"});
        this.getChildren().addAll((Object[])new Node[]{this.titleLabel, this.descriptionLabel, this.seperator});
        this.hidden = new SimpleBooleanProperty(false);
    }

    public boolean isHidden() {
        return this.hidden.get();
    }

    public void toggleVisibility() {
        if (this.isHidden()) {
            this.show();
        } else {
            this.hide();
        }
    }

    private void stopAnimations() {
        if (this.showAnimation != null) {
            this.showAnimation.pause();
        }
        if (this.hideAnimation != null) {
            this.hideAnimation.pause();
        }
    }

    public void hide() {
        this.stopAnimations();
        this.hidden.setValue(Boolean.valueOf(true));
        TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)360.0), (Node)this);
        translateTransition.setInterpolator(Interpolator.EASE_IN);
        translateTransition.setFromY(this.getTranslateY());
        translateTransition.toYProperty().bind((ObservableValue)this.heightProperty());
        FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)360.0), (Node)this);
        fadeTransition.setFromValue(this.getOpacity());
        fadeTransition.setToValue(0.0);
        this.hideAnimation = new ParallelTransition(new Animation[]{translateTransition, fadeTransition});
        this.hideAnimation.play();
    }

    public void show() {
        this.stopAnimations();
        this.hidden.setValue(Boolean.valueOf(false));
        TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)360.0), (Node)this);
        translateTransition.setInterpolator(Interpolator.EASE_IN);
        translateTransition.setFromY(this.getTranslateY());
        translateTransition.setToY(0.0);
        FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)360.0), (Node)this);
        fadeTransition.setFromValue(this.getOpacity());
        fadeTransition.setToValue(1.0);
        this.showAnimation = new ParallelTransition(new Animation[]{translateTransition, fadeTransition});
        this.showAnimation.play();
    }

    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.titleLabel.relocate(this.getPadding().getLeft(), this.getPadding().getTop());
        double titleLabelHeight = this.titleLabel.prefHeight(this.getWidth() - this.getPadding().getLeft() - this.getPadding().getRight());
        this.titleLabel.resize(this.getWidth() - this.getPadding().getLeft() - this.getPadding().getRight(), titleLabelHeight);
        this.seperator.setStartX(this.getPadding().getLeft());
        this.seperator.setEndX(this.getWidth() - this.getPadding().getRight());
        this.seperator.setStartY(this.getPadding().getTop() + titleLabelHeight + 2.0);
        this.seperator.setEndY(this.getPadding().getTop() + titleLabelHeight + 6.0);
        this.descriptionLabel.relocate(this.getPadding().getLeft(), this.getPadding().getTop() + titleLabelHeight + 2.0 + 6.0);
        double descriptionLabelHeight = this.descriptionLabel.prefHeight(this.getWidth() - this.getPadding().getLeft() - this.getPadding().getRight());
        this.descriptionLabel.resize(this.getWidth() - this.getPadding().getLeft() - this.getPadding().getRight(), descriptionLabelHeight);
    }

    protected double computePrefHeight(double width) {
        double widthWithPadding = width - this.getPadding().getLeft() - this.getPadding().getRight();
        return this.getPadding().getTop() + this.titleLabel.prefHeight(widthWithPadding) + 2.0 + this.seperator.prefHeight(widthWithPadding) + 6.0 + this.descriptionLabel.prefHeight(widthWithPadding) + this.getPadding().getBottom();
    }
}

