/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.menu;

import com.guigarage.sdk.action.Action;
import com.guigarage.sdk.menu.MenuEntry;
import com.guigarage.sdk.util.Callback;
import com.guigarage.sdk.util.Media;
import com.guigarage.sdk.util.RoundImageView;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class MenuPane
extends VBox {
    private ObservableList<Action> entries;
    private Map<Action, Node> itemToNode;
    private Callback globalActionCallback;
    private ObjectProperty<Node> header = new SimpleObjectProperty();
    private ObjectProperty<Node> footer;

    public MenuPane() {
        this.header.addListener((obs, oldV, newV) -> {
            if (oldV != null) {
                this.getChildren().remove(oldV);
            }
            if (newV != null) {
                this.getChildren().add(0, newV);
            }
        });
        this.footer = new SimpleObjectProperty();
        this.footer.addListener((obs, oldV, newV) -> {
            if (oldV != null) {
                this.getChildren().remove(oldV);
            }
            if (newV != null) {
                this.getChildren().add(newV);
            }
        });
        this.getStyleClass().add((Object)"menu-pane");
        this.setFillWidth(true);
        this.entries = FXCollections.observableArrayList();
        this.itemToNode = new HashMap<Action, Node>();
        this.entries.addListener(c -> {
            while (c.next()) {
                if (c.wasPermutated() || c.wasUpdated()) continue;
                for (Action removed : c.getRemoved()) {
                    Node child = this.itemToNode.remove(removed);
                    this.getChildren().remove((Object)child);
                }
                for (Action added : c.getAddedSubList()) {
                    MenuEntry entry = this.createMenuEntry(added);
                    this.getChildren().add((Object)entry);
                    this.itemToNode.put(added, (Node)entry);
                }
                if (this.footer.get() == null) continue;
                ((Node)this.footer.get()).toFront();
            }
        });
    }

    private MenuEntry createMenuEntry(Action action) {
        MenuEntry entry = new MenuEntry();
        entry.setText(action.getTitle());
        entry.setIcon(action.getIcon());
        entry.setCallback(() -> {
            if (action.getCallback() != null) {
                action.getCallback().call();
            }
            if (this.globalActionCallback != null) {
                this.globalActionCallback.call();
            }
        });
        return entry;
    }

    public void setHeader(Media media) {
        HBox mediaView = new HBox();
        mediaView.getStyleClass().add((Object)"menu-media-header");
        RoundImageView imageView = new RoundImageView();
        imageView.imageProperty().bind(media.imageProperty());
        VBox textBox = new VBox();
        Label titleLabel = new Label();
        titleLabel.getStyleClass().add((Object)"media-title");
        titleLabel.textProperty().bind((ObservableValue)media.titleProperty());
        Label descriptionLabel = new Label();
        descriptionLabel.getStyleClass().add((Object)"media-description");
        descriptionLabel.setWrapText(true);
        descriptionLabel.textProperty().bind((ObservableValue)media.descriptionProperty());
        textBox.getChildren().addAll((Object[])new Node[]{titleLabel, descriptionLabel});
        mediaView.getChildren().addAll((Object[])new Node[]{imageView, textBox});
        this.setHeader((Node)mediaView);
    }

    public void setActionAsFooter(Action action) {
        this.setFooter((Node)this.createMenuEntry(action));
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.footer.get() != null) {
            ((Node)this.footer.get()).relocate(this.getPadding().getLeft(), this.getHeight() - this.getPadding().getBottom() - ((Node)this.footer.get()).getBoundsInParent().getHeight());
        }
    }

    public void setGlobalActionCallback(Callback globalActionCallback) {
        this.globalActionCallback = globalActionCallback;
    }

    public Node getHeader() {
        return (Node)this.header.get();
    }

    public ObjectProperty<Node> headerProperty() {
        return this.header;
    }

    public void setHeader(Node header) {
        this.header.set((Object)header);
    }

    public Node getFooter() {
        return (Node)this.footer.get();
    }

    public ObjectProperty<Node> footerProperty() {
        return this.footer;
    }

    public void setFooter(Node footer) {
        this.footer.set((Object)footer);
    }

    public void add(Action action) {
        this.entries.add((Object)action);
    }

    public void remove(Action action) {
        this.entries.remove((Object)action);
    }
}

