/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.menu;

import com.guigarage.sdk.util.Callback;
import com.guigarage.sdk.util.FontBasedIcon;
import java.util.Optional;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.Region;

public class MenuEntry
extends Region {
    private DoubleProperty iconWidth;
    private DoubleProperty iconTextGapWidth;
    private StringProperty text;
    private ObjectProperty<FontBasedIcon> icon;
    private ObjectProperty<Callback> callback;
    private Label textLabel;
    private Label iconLabel;
    private ObjectProperty<Node> rightNode;
    private PseudoClass hightlightPseudoclass = PseudoClass.getPseudoClass((String)"highlighted");

    public MenuEntry() {
        this.getStyleClass().add((Object)"menu-entry");
        this.iconWidth = new SimpleDoubleProperty(24.0);
        this.iconWidth.addListener(e -> this.requestLayout());
        this.iconTextGapWidth = new SimpleDoubleProperty(12.0);
        this.iconTextGapWidth.addListener(e -> this.requestLayout());
        this.text = new SimpleStringProperty();
        this.icon = new SimpleObjectProperty();
        this.callback = new SimpleObjectProperty();
        this.textLabel = new Label();
        this.textLabel.getStyleClass().add((Object)"menu-entry-text");
        this.textLabel.textProperty().bind((ObservableValue)this.text);
        this.getChildren().add((Object)this.textLabel);
        this.iconLabel = new Label();
        this.iconLabel.getStyleClass().add((Object)"menu-entry-icon");
        this.icon.addListener(e -> {
            if (this.icon.get() != null) {
                this.iconLabel.setText(((FontBasedIcon)this.icon.get()).getText());
            } else {
                this.iconLabel.setText("");
            }
        });
        this.getChildren().add((Object)this.iconLabel);
        this.rightNode = new SimpleObjectProperty();
        this.rightNode.addListener((obs, oldValue, newValue) -> {
            if (oldValue != null) {
                this.getChildren().remove(oldValue);
            }
            if (newValue != null) {
                this.getChildren().add(newValue);
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> Optional.ofNullable(this.callback.get()).ifPresent(c -> c.call()));
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, e -> Optional.ofNullable(this.callback.get()).ifPresent(c -> c.call()));
        this.addEventFilter(MouseEvent.MOUSE_ENTERED, e -> this.pseudoClassStateChanged(this.hightlightPseudoclass, true));
        this.addEventFilter(MouseEvent.MOUSE_EXITED, e -> this.pseudoClassStateChanged(this.hightlightPseudoclass, false));
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.setMaxWidth(Double.MAX_VALUE);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.setMinWidth(Double.NEGATIVE_INFINITY);
    }

    protected void layoutChildren() {
        this.iconLabel.resize(this.iconWidth.get(), this.iconWidth.get());
        this.iconLabel.relocate(this.getPadding().getLeft(), this.getHeight() / 2.0 - this.iconWidth.get() / 2.0);
        this.textLabel.resize(this.textLabel.prefWidth(-1.0), this.textLabel.prefHeight(-1.0));
        this.textLabel.relocate(this.getPadding().getLeft() + this.iconWidth.get() + this.iconTextGapWidth.get(), this.getHeight() / 2.0 - this.textLabel.getHeight() / 2.0);
        if (this.rightNode.get() != null) {
            double rightNodePrefWidth = ((Node)this.rightNode.get()).prefWidth(this.getHeight());
            ((Node)this.rightNode.get()).resize(rightNodePrefWidth, ((Node)this.rightNode.get()).prefHeight(-1.0));
            this.textLabel.relocate(this.getWidth() - this.getPadding().getRight() - rightNodePrefWidth, this.getHeight() / 2.0 - this.textLabel.getHeight() / 2.0);
        }
    }

    protected double computePrefHeight(double width) {
        double heightByIcon = this.iconWidth.get();
        double heightByLabel = this.textLabel.prefHeight(-1.0);
        double heightByRightComp = 0.0;
        if (this.rightNode.get() != null) {
            heightByRightComp = ((Node)this.rightNode.get()).prefHeight(-1.0);
        }
        return this.getPadding().getTop() + this.getPadding().getBottom() + Math.max(heightByIcon, Math.max(heightByLabel, heightByRightComp));
    }

    protected double computePrefWidth(double height) {
        double rightCompWidth = 0.0;
        if (this.rightNode.get() != null) {
            rightCompWidth = ((Node)this.rightNode.get()).prefWidth(height);
        }
        return this.getPadding().getLeft() + this.iconWidth.get() + this.iconTextGapWidth.get() + this.textLabel.prefWidth(height) + this.iconTextGapWidth.get() + rightCompWidth + this.getPadding().getRight();
    }

    public Node getRightNode() {
        return (Node)this.rightNode.get();
    }

    public ObjectProperty<Node> rightNodeProperty() {
        return this.rightNode;
    }

    public void setRightNode(Node rightNode) {
        this.rightNode.set((Object)rightNode);
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public FontBasedIcon getIcon() {
        return (FontBasedIcon)this.icon.get();
    }

    public ObjectProperty<FontBasedIcon> iconProperty() {
        return this.icon;
    }

    public void setIcon(FontBasedIcon icon) {
        this.icon.set((Object)icon);
    }

    public Callback getCallback() {
        return (Callback)this.callback.get();
    }

    public ObjectProperty<Callback> callbackProperty() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        this.callback.set((Object)callback);
    }
}

