/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.list;

import com.guigarage.sdk.css.CssHelper;
import com.guigarage.sdk.css.SkinPropertyBasedCssMetaData;
import com.guigarage.sdk.list.StructuredListCell;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;

public class StructuredListCellSkin
extends SkinBase<StructuredListCell> {
    private StyleableObjectProperty<VPos> leftContentAlignment;
    private StyleableObjectProperty<VPos> rightContentAlignment;
    private StyleableObjectProperty<Pos> centerContentAlignment;
    private StyleableObjectProperty<Number> spacing;
    private StyleableObjectProperty<HPos> componentForPrefHeight;

    protected StructuredListCellSkin(StructuredListCell control) {
        super((Control)control);
        ((StructuredListCell)this.getSkinnable()).leftContentProperty().addListener(e -> this.updateContent());
        ((StructuredListCell)this.getSkinnable()).centerContentProperty().addListener(e -> this.updateContent());
        ((StructuredListCell)this.getSkinnable()).rightContentProperty().addListener(e -> this.updateContent());
        this.updateContent();
        this.leftContentAlignment = CssHelper.createProperty(StyleableProperties.LEFT_CONTENT_ALIGNMENT, this);
        this.rightContentAlignment = CssHelper.createProperty(StyleableProperties.RIGHT_CONTENT_ALIGNMENT, this);
        this.centerContentAlignment = CssHelper.createProperty(StyleableProperties.CENTER_CONTENT_ALIGNMENT, this);
        this.spacing = CssHelper.createProperty(StyleableProperties.SPACING, this);
        this.componentForPrefHeight = CssHelper.createProperty(StyleableProperties.CONTENT_FOR_PREF_HEIGHT, this);
        ((StructuredListCell)this.getSkinnable()).itemProperty().addListener(e -> this.updateVisibility());
        ((StructuredListCell)this.getSkinnable()).setMaxHeight(Double.NEGATIVE_INFINITY);
        ((StructuredListCell)this.getSkinnable()).setMinHeight(Double.NEGATIVE_INFINITY);
    }

    public Number getSpacing() {
        return (Number)this.spacing.get();
    }

    public void setSpacing(Number spacing) {
        this.spacing.set((Object)spacing);
    }

    public StyleableObjectProperty<Number> spacingProperty() {
        return this.spacing;
    }

    public VPos getLeftContentAlignment() {
        return (VPos)this.leftContentAlignment.get();
    }

    public void setLeftContentAlignment(VPos leftContentAlignment) {
        this.leftContentAlignment.set((Object)leftContentAlignment);
    }

    public StyleableObjectProperty<VPos> leftContentAlignmentProperty() {
        return this.leftContentAlignment;
    }

    public VPos getRightContentAlignment() {
        return (VPos)this.rightContentAlignment.get();
    }

    public void setRightContentAlignment(VPos rightContentAlignment) {
        this.rightContentAlignment.set((Object)rightContentAlignment);
    }

    public StyleableObjectProperty<VPos> rightContentAlignmentProperty() {
        return this.rightContentAlignment;
    }

    public Pos getCenterContentAlignment() {
        return (Pos)this.centerContentAlignment.get();
    }

    public void setCenterContentAlignment(Pos centerContentAlignment) {
        this.centerContentAlignment.set((Object)centerContentAlignment);
    }

    public StyleableObjectProperty<Pos> centerContentAlignmentProperty() {
        return this.centerContentAlignment;
    }

    public HPos getComponentForPrefHeight() {
        return (HPos)this.componentForPrefHeight.get();
    }

    public void setComponentForPrefHeight(HPos componentForPrefHeight) {
        this.componentForPrefHeight.set((Object)componentForPrefHeight);
    }

    public StyleableObjectProperty<HPos> componentForPrefHeightProperty() {
        return this.componentForPrefHeight;
    }

    private void updateVisibility() {
        Consumer<Node> c = n -> n.setVisible(((StructuredListCell)this.getSkinnable()).getItem() != null);
        Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getLeftContent()).ifPresent(c);
        Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getCenterContent()).ifPresent(c);
        Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getRightContent()).ifPresent(c);
    }

    private void updateContent() {
        this.getChildren().clear();
        if (((StructuredListCell)this.getSkinnable()).leftContentProperty().get() != null) {
            this.getChildren().add((Object)((StructuredListCell)this.getSkinnable()).getLeftContent());
        }
        if (((StructuredListCell)this.getSkinnable()).centerContentProperty().get() != null) {
            this.getChildren().add((Object)((StructuredListCell)this.getSkinnable()).getCenterContent());
        }
        if (((StructuredListCell)this.getSkinnable()).rightContentProperty().get() != null) {
            this.getChildren().add((Object)((StructuredListCell)this.getSkinnable()).getRightContent());
        }
        this.updateVisibility();
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double leftContentWidth = 0.0;
        if (((StructuredListCell)this.getSkinnable()).getLeftContent() != null) {
            Node leftContent = ((StructuredListCell)this.getSkinnable()).getLeftContent();
            leftContentWidth = leftContent.prefWidth(contentHeight);
            double leftContentHeight = Math.min(leftContent.prefHeight(leftContentWidth), contentHeight);
            leftContent.resize(leftContentWidth, leftContentHeight);
            if (((VPos)this.leftContentAlignment.get()).equals((Object)VPos.TOP)) {
                leftContent.relocate(contentX, contentY);
            } else if (((VPos)this.leftContentAlignment.get()).equals((Object)VPos.CENTER)) {
                leftContent.relocate(contentX, contentY + (contentHeight - leftContentHeight) / 2.0);
            } else {
                leftContent.relocate(contentX, contentY + (contentHeight - leftContentHeight));
            }
        }
        double rightContentWidth = 0.0;
        if (((StructuredListCell)this.getSkinnable()).getRightContent() != null) {
            Node rightContent = ((StructuredListCell)this.getSkinnable()).getRightContent();
            rightContentWidth = rightContent.prefWidth(contentHeight);
            double rightContentHeight = Math.min(rightContent.prefHeight(rightContentWidth), contentHeight);
            rightContent.resize(rightContentWidth, rightContentHeight);
            if (((VPos)this.rightContentAlignment.get()).equals((Object)VPos.TOP)) {
                rightContent.relocate(contentX + contentWidth - rightContentWidth, contentY);
            } else if (((VPos)this.rightContentAlignment.get()).equals((Object)VPos.CENTER)) {
                rightContent.relocate(contentX + contentWidth - rightContentWidth, contentY + (contentHeight - rightContentHeight) / 2.0);
            } else {
                rightContent.relocate(contentX + contentWidth - rightContentWidth, contentY + (contentHeight - rightContentHeight));
            }
        }
        if (((StructuredListCell)this.getSkinnable()).getCenterContent() != null) {
            Node centerContent = ((StructuredListCell)this.getSkinnable()).getCenterContent();
            double maxWidthForCenterContent = contentWidth - leftContentWidth - rightContentWidth - ((Number)this.spacing.get()).doubleValue() * 2.0;
            double maxHeigthForCenterContent = contentHeight;
            double centerContentWidth = Math.min(centerContent.maxWidth(contentHeight), maxWidthForCenterContent);
            double centerContentHeight = Math.min(centerContent.maxHeight(centerContentWidth), maxHeigthForCenterContent);
            centerContent.resize(centerContentWidth, centerContentHeight);
            if (((Pos)this.centerContentAlignment.get()).equals((Object)Pos.TOP_LEFT)) {
                centerContent.relocate(contentX + leftContentWidth + ((Number)this.spacing.get()).doubleValue(), contentY);
            } else if (((Pos)this.centerContentAlignment.get()).equals((Object)Pos.TOP_CENTER)) {
                centerContent.relocate(contentX + leftContentWidth + ((Number)this.spacing.get()).doubleValue() + (maxWidthForCenterContent - centerContentWidth) / 2.0, contentY);
            } else if (((Pos)this.centerContentAlignment.get()).equals((Object)Pos.TOP_RIGHT)) {
                centerContent.relocate(contentX + leftContentWidth + ((Number)this.spacing.get()).doubleValue() + (maxWidthForCenterContent - centerContentWidth), contentY);
            } else if (((Pos)this.centerContentAlignment.get()).equals((Object)Pos.CENTER_LEFT)) {
                centerContent.relocate(contentX + leftContentWidth + ((Number)this.spacing.get()).doubleValue(), contentY + (maxHeigthForCenterContent - centerContentHeight) / 2.0);
            } else if (((Pos)this.centerContentAlignment.get()).equals((Object)Pos.CENTER)) {
                centerContent.relocate(contentX + leftContentWidth + ((Number)this.spacing.get()).doubleValue() + (maxWidthForCenterContent - centerContentWidth) / 2.0, contentY + (maxHeigthForCenterContent - centerContentHeight) / 2.0);
            } else if (((Pos)this.centerContentAlignment.get()).equals((Object)Pos.CENTER_RIGHT)) {
                centerContent.relocate(contentX + leftContentWidth + ((Number)this.spacing.get()).doubleValue() + (maxWidthForCenterContent - centerContentWidth), contentY + (maxHeigthForCenterContent - centerContentHeight) / 2.0);
            } else if (((Pos)this.centerContentAlignment.get()).equals((Object)Pos.BOTTOM_LEFT)) {
                centerContent.relocate(contentX + leftContentWidth + ((Number)this.spacing.get()).doubleValue(), contentY + (maxHeigthForCenterContent - centerContentHeight));
            } else if (((Pos)this.centerContentAlignment.get()).equals((Object)Pos.BOTTOM_CENTER)) {
                centerContent.relocate(contentX + leftContentWidth + ((Number)this.spacing.get()).doubleValue() + (maxWidthForCenterContent - centerContentWidth) / 2.0, contentY + (maxHeigthForCenterContent - centerContentHeight));
            } else {
                centerContent.relocate(contentX + leftContentWidth + ((Number)this.spacing.get()).doubleValue() + (maxWidthForCenterContent - centerContentWidth), contentY + (maxHeigthForCenterContent - centerContentHeight));
            }
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double leftComponentMinWidth = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getLeftContent()).map(n -> n.minWidth(height)).orElse(0.0);
        double rightComponentMinWidth = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getRightContent()).map(n -> n.minWidth(height)).orElse(0.0);
        double centerComponentMinWidth = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getCenterContent()).map(n -> n.minWidth(height)).orElse(0.0);
        return leftInset + leftComponentMinWidth + ((Number)this.spacing.get()).doubleValue() + centerComponentMinWidth + ((Number)this.spacing.get()).doubleValue() + rightComponentMinWidth + rightInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double leftComponentMaxWidth = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getLeftContent()).map(n -> n.maxWidth(height)).orElse(0.0);
        double rightComponentMaxWidth = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getRightContent()).map(n -> n.maxWidth(height)).orElse(0.0);
        double centerComponentMaxWidth = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getCenterContent()).map(n -> n.maxWidth(height)).orElse(0.0);
        return leftInset + leftComponentMaxWidth + ((Number)this.spacing.get()).doubleValue() + centerComponentMaxWidth + ((Number)this.spacing.get()).doubleValue() + rightComponentMaxWidth + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefWidthOfLeftComponent = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getLeftContent()).map(n -> n.prefWidth(-1.0)).orElse(0.0);
        double minWidthOfCenterComponent = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getCenterContent()).map(n -> n.minWidth(-1.0)).orElse(0.0);
        double prefWidthOfRightComponent = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getRightContent()).map(n -> n.prefWidth(-1.0)).orElse(0.0);
        if (((HPos)this.componentForPrefHeight.get()).equals((Object)HPos.LEFT)) {
            if (((StructuredListCell)this.getSkinnable()).getLeftContent() == null) {
                return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
            }
            double useableWidth = width - this.getSpacing().doubleValue() - minWidthOfCenterComponent - this.getSpacing().doubleValue() - prefWidthOfRightComponent;
            return Math.max(((StructuredListCell)this.getSkinnable()).getLeftContent().prefHeight(useableWidth) + topInset + bottomInset, super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset));
        }
        if (((HPos)this.componentForPrefHeight.get()).equals((Object)HPos.RIGHT)) {
            if (((StructuredListCell)this.getSkinnable()).getRightContent() == null) {
                return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
            }
            double useableWidth = width - prefWidthOfLeftComponent - this.getSpacing().doubleValue() - minWidthOfCenterComponent - this.getSpacing().doubleValue();
            return Math.max(((StructuredListCell)this.getSkinnable()).getRightContent().prefHeight(useableWidth) + topInset + bottomInset, super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset));
        }
        if (((StructuredListCell)this.getSkinnable()).getCenterContent() == null) {
            return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        }
        double useableWidth = width - prefWidthOfLeftComponent - this.getSpacing().doubleValue() - this.getSpacing().doubleValue() - prefWidthOfRightComponent;
        if (useableWidth <= 0.0) {
            return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        }
        return Math.max(((StructuredListCell)this.getSkinnable()).getCenterContent().prefHeight(useableWidth) + topInset + bottomInset, super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset));
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double leftComponentPrefWidth = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getLeftContent()).map(n -> n.prefWidth(height)).orElse(0.0);
        double rightComponentPrefWidth = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getRightContent()).map(n -> n.prefWidth(height)).orElse(0.0);
        double centerComponentMinWidth = Optional.ofNullable(((StructuredListCell)this.getSkinnable()).getCenterContent()).map(n -> n.minWidth(height)).orElse(0.0);
        return leftInset + leftComponentPrefWidth + ((Number)this.spacing.get()).doubleValue() + centerComponentMinWidth + ((Number)this.spacing.get()).doubleValue() + rightComponentPrefWidth + rightInset;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final SkinPropertyBasedCssMetaData<StructuredListCell, VPos> LEFT_CONTENT_ALIGNMENT = CssHelper.createSkinMetaDataForVPos("-fx-left-alignment", "leftContentAlignment", VPos.TOP);
        private static final SkinPropertyBasedCssMetaData<StructuredListCell, VPos> RIGHT_CONTENT_ALIGNMENT = CssHelper.createSkinMetaDataForVPos("-fx-right-alignment", "rightContentAlignment", VPos.TOP);
        private static final SkinPropertyBasedCssMetaData<StructuredListCell, HPos> CONTENT_FOR_PREF_HEIGHT = CssHelper.createSkinMetaDataForHPos("-fx-height-rule", "componentForPrefHeight", HPos.CENTER);
        private static final SkinPropertyBasedCssMetaData<StructuredListCell, Number> SPACING = CssHelper.createSkinMetaData("-fx-spacing", StyleConverter.getSizeConverter(), "spacing", 0);
        private static final SkinPropertyBasedCssMetaData<StructuredListCell, Pos> CENTER_CONTENT_ALIGNMENT = CssHelper.createSkinMetaDataForPos("-fx-center-alignment", "centerContentAlignment", Pos.TOP_LEFT);
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES = CssHelper.createCssMetaDataList(StructuredListCell.getClassCssMetaData(), LEFT_CONTENT_ALIGNMENT, RIGHT_CONTENT_ALIGNMENT, CONTENT_FOR_PREF_HEIGHT, SPACING, CENTER_CONTENT_ALIGNMENT);

        private StyleableProperties() {
        }
    }
}

