/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.list;

import com.guigarage.sdk.css.CssHelper;
import com.guigarage.sdk.css.DefaultPropertyBasedCssMetaData;
import com.guigarage.sdk.list.StructuredListCell;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class MediaListCell<T>
extends StructuredListCell<T> {
    private Label titleLabel;
    private Label descriptionLabel;
    private VBox centerBox;
    private StyleableObjectProperty<Boolean> showDescription;
    private StringProperty title;
    private StringProperty description;
    private StyleableObjectProperty<Number> textSpacing;

    public MediaListCell() {
        this.getStyleClass().add((Object)"media-list-cell");
        this.title = new SimpleStringProperty();
        this.description = new SimpleStringProperty();
        this.textSpacing = CssHelper.createProperty(StyleableProperties.TEXT_SPACING, this);
        this.showDescription = CssHelper.createProperty(StyleableProperties.SHOW_DESCRIPTION, this);
        this.centerBox = new VBox();
        this.centerBox.spacingProperty().bind(this.textSpacing);
        this.titleLabel = new Label();
        this.titleLabel.getStyleClass().add((Object)"media-cell-title");
        this.titleLabel.textProperty().bind((ObservableValue)this.title);
        VBox.setVgrow((Node)this.titleLabel, (Priority)Priority.NEVER);
        this.descriptionLabel = new Label();
        this.descriptionLabel.setWrapText(true);
        this.descriptionLabel.setTextOverrun(OverrunStyle.WORD_ELLIPSIS);
        this.descriptionLabel.getStyleClass().add((Object)"media-cell-description");
        this.descriptionLabel.textProperty().bind((ObservableValue)this.description);
        VBox.setVgrow((Node)this.descriptionLabel, (Priority)Priority.ALWAYS);
        this.centerBox.getChildren().addAll((Object[])new Node[]{this.titleLabel, this.descriptionLabel});
        this.setCenterContent((Node)this.centerBox);
        this.showDescription.addListener(e -> {
            this.descriptionLabel.setManaged(this.isShowDescription());
            this.descriptionLabel.setVisible(this.isShowDescription());
        });
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public Number getTextSpacing() {
        return (Number)this.textSpacing.get();
    }

    public void setTextSpacing(Number textSpacing) {
        this.textSpacing.set((Object)textSpacing);
    }

    public ObjectProperty<Number> textSpacingProperty() {
        return this.textSpacing;
    }

    public boolean isShowDescription() {
        return (Boolean)this.showDescription.get();
    }

    public void setShowDescription(boolean showDescription) {
        this.showDescription.set((Object)showDescription);
    }

    public StyleableObjectProperty<Boolean> showDescriptionProperty() {
        return this.showDescription;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public Label getDescriptionLabel() {
        return this.descriptionLabel;
    }

    private static class StyleableProperties {
        private static final DefaultPropertyBasedCssMetaData<MediaListCell, Boolean> SHOW_DESCRIPTION = CssHelper.createMetaData("-fx-show-description", StyleConverter.getBooleanConverter(), "showDescription", Boolean.FALSE);
        private static final DefaultPropertyBasedCssMetaData<MediaListCell, Number> TEXT_SPACING = CssHelper.createMetaData("-fx-text-spacing", StyleConverter.getSizeConverter(), "textSpacing", 0);
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES = CssHelper.createCssMetaDataList(StructuredListCell.getClassCssMetaData(), SHOW_DESCRIPTION, TEXT_SPACING);

        private StyleableProperties() {
        }
    }
}

