/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.image;

import com.guigarage.sdk.overlay.Overlay;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;

public class SimpleImageView
extends Region {
    private ObjectProperty<Overlay> overlay;
    private ImageView imageView;
    private BooleanProperty calcRatioByShortSite;

    public SimpleImageView() {
        this.getStyleClass().add((Object)"simple-image-view");
        this.imageView = new ImageView();
        this.imageView.setSmooth(true);
        this.imageView.setPreserveRatio(true);
        this.getChildren().add((Object)this.imageView);
        this.overlay = new SimpleObjectProperty();
        this.overlay.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.getChildren().remove((Object)oldValue);
            }
            if (newValue != null) {
                this.getChildren().add((Object)newValue);
            }
        });
        this.calcRatioByShortSite = new SimpleBooleanProperty(true);
        this.calcRatioByShortSite.addListener(e -> this.imageView.fitWidthProperty().bind((ObservableValue)this.widthProperty()));
        this.calcRatioByShortSite.setValue(Boolean.valueOf(false));
    }

    public void setImage(String url) {
        this.imageView.setImage(new Image(url));
    }

    public void setImage(Image image) {
        this.imageView.setImage(image);
    }

    public void setOverlay(Overlay overlay) {
        this.overlay.setValue((Object)overlay);
    }

    public void hideOverlay() {
        if (this.overlay.get() != null) {
            ((Overlay)((Object)this.overlay.get())).hide();
        }
    }

    public void showOverlay() {
        if (this.overlay.get() != null) {
            ((Overlay)((Object)this.overlay.get())).show();
        }
    }

    public boolean isOverlayHidden() {
        if (this.overlay.get() != null) {
            return ((Overlay)((Object)this.overlay.get())).isHidden();
        }
        return false;
    }

    public void toggleOverlayVisibility() {
        if (this.overlay.get() != null) {
            ((Overlay)((Object)this.overlay.get())).toggleVisibility();
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.imageView.relocate(0.0, 0.0);
        this.imageView.resize(this.getWidth(), this.getHeight());
        if (this.overlay.get() != null) {
            double height = ((Overlay)((Object)this.overlay.get())).prefHeight(this.getWidth());
            ((Overlay)((Object)this.overlay.get())).relocate(0.0, this.getHeight() - height);
            ((Overlay)((Object)this.overlay.get())).resize(this.getWidth(), height);
        }
    }
}

