/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.form;

import com.guigarage.sdk.form.FormRow;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;

public class HeaderFormRow
implements FormRow {
    private VBox layout = new VBox();

    public HeaderFormRow(String title) {
        this(title, null);
    }

    public HeaderFormRow(String title, String description) {
        Label titleLabel = new Label(title);
        titleLabel.getStyleClass().add((Object)"form-header-title");
        Label descriptionLabel = new Label(description);
        descriptionLabel.getStyleClass().add((Object)"form-header-description");
        this.layout.getChildren().addAll((Object[])new Node[]{titleLabel, descriptionLabel});
    }

    @Override
    public double getPrefLabelWidth() {
        return -1.0;
    }

    @Override
    public double layoutInParent(double startX, double startY, double width, double labelWidth, double rowSpacing, double columnSpacing) {
        this.layout.relocate(startX, startY);
        double layoutHeight = this.layout.prefHeight(width);
        this.layout.resize(width, layoutHeight);
        return startY + layoutHeight + rowSpacing;
    }

    @Override
    public List<Node> getNodes() {
        return FXCollections.observableArrayList((Object[])new Node[]{this.layout});
    }
}

