/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.form;

import com.guigarage.sdk.action.Action;
import com.guigarage.sdk.form.ActionFormRow;
import com.guigarage.sdk.form.EditorFormRow;
import com.guigarage.sdk.form.EditorType;
import com.guigarage.sdk.form.FormEditor;
import com.guigarage.sdk.form.FormRow;
import com.guigarage.sdk.form.HeaderFormRow;
import com.guigarage.sdk.form.SeperatorFormRow;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.layout.Region;

public class FormLayout
extends Region {
    private DoubleProperty labelEditorSpacing;
    private DoubleProperty rowSpacing;
    private List<FormRow> rows;
    private static final int ROW_MARGIN = 12;

    public FormLayout() {
        this.getStyleClass().addAll((Object[])new String[]{"form-layout"});
        this.labelEditorSpacing = new SimpleDoubleProperty(12.0);
        this.rowSpacing = new SimpleDoubleProperty(8.0);
        this.rows = new ArrayList<FormRow>();
    }

    public void addSeperator() {
        this.add(new SeperatorFormRow());
    }

    public void addHeader(String title) {
        this.add(new HeaderFormRow(title));
    }

    public void addActions(Action ... actions) {
        this.add(new ActionFormRow(actions));
    }

    public void addHeader(String title, String description) {
        this.add(new HeaderFormRow(title, description));
    }

    public FormEditor addField(String name) {
        return this.addField(name, EditorType.TEXTFIELD);
    }

    public FormEditor addField(String name, EditorType type) {
        EditorFormRow row = EditorFormRow.newEditorFormRow(name, type);
        this.add(row);
        return row.getFormEditor();
    }

    public void add(FormRow row) {
        this.getChildren().addAll(row.getNodes());
        this.rows.add(row);
    }

    protected void layoutChildren() {
        double labelWidth = this.computeLabelWidth();
        double rowStartY = this.getPadding().getTop();
        for (FormRow row : this.rows) {
            rowStartY = row.layoutInParent(this.getPadding().getLeft(), rowStartY, this.getWidth() - this.getPadding().getLeft() - this.getPadding().getRight(), labelWidth, this.rowSpacing.get(), this.labelEditorSpacing.get()) + 12.0;
        }
    }

    private double computeLabelWidth() {
        double width = 0.0;
        for (FormRow row : this.rows) {
            double prefLabelWidth = row.getPrefLabelWidth();
            if (!(prefLabelWidth > width)) continue;
            width = prefLabelWidth;
        }
        return width;
    }
}

