/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.form;

import com.guigarage.sdk.form.EditorType;
import com.guigarage.sdk.form.FormEditor;
import com.guigarage.sdk.form.FormRow;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.text.TextAlignment;

public class EditorFormRow<T extends Node>
implements FormRow {
    private Label label;
    private T editor;
    private FormEditor formEditor;

    public EditorFormRow(String labelText, T editor) {
        this.editor = editor;
        this.label = this.createLabel(labelText, (Node)editor);
        this.label.disableProperty().bind((ObservableValue)editor.disableProperty());
        this.label.visibleProperty().bind((ObservableValue)editor.visibleProperty());
        SimpleStringProperty nameProperty = new SimpleStringProperty();
        nameProperty.addListener(arg_0 -> this.lambda$new$0((StringProperty)nameProperty, arg_0));
        this.formEditor = new FormEditor(editor.disableProperty(), (StringProperty)nameProperty, editor.visibleProperty());
    }

    private Label createLabel(String text, Node editor) {
        return this.createLabel((StringProperty)new SimpleStringProperty(text), editor);
    }

    private Label createLabel(StringProperty text, Node editor) {
        Label label = new Label();
        label.getStyleClass().add((Object)"form-label");
        text.addListener(e -> label.setText((String)text.get() + ":"));
        label.setText((String)text.get() + ":");
        label.setTextAlignment(TextAlignment.RIGHT);
        label.setAlignment(Pos.BASELINE_RIGHT);
        if (editor instanceof TextArea) {
            label.setAlignment(Pos.TOP_RIGHT);
        }
        label.setLabelFor(editor);
        return label;
    }

    @Override
    public double getPrefLabelWidth() {
        return this.label.prefWidth(-1.0);
    }

    @Override
    public double layoutInParent(double startX, double startY, double width, double labelWidth, double rowSpacing, double columnSpacing) {
        if (this.label.isVisible()) {
            double editorWidth = width - columnSpacing - labelWidth;
            double labelHeight = this.label.prefHeight(labelWidth);
            double editorHeight = this.editor.prefHeight(editorWidth);
            double height = Math.max(labelHeight, editorHeight);
            this.label.relocate(startX, startY);
            this.label.resize(labelWidth, height);
            this.editor.relocate(this.label.getLayoutX() + this.label.getWidth() + columnSpacing, startY);
            this.editor.resize(editorWidth, height);
            return startY + Math.max(this.label.getHeight(), this.editor.getLayoutBounds().getHeight()) + rowSpacing;
        }
        return startY;
    }

    @Override
    public List<Node> getNodes() {
        return FXCollections.observableArrayList((Object[])new Node[]{this.label, this.editor});
    }

    public Label getLabel() {
        return this.label;
    }

    public T getEditor() {
        return this.editor;
    }

    public FormEditor getFormEditor() {
        return this.formEditor;
    }

    public static EditorFormRow newEditorFormRow(String label, EditorType editorType) {
        EditorFormRow<TextField> row = null;
        switch (editorType) {
            case TEXTFIELD: {
                row = EditorFormRow.newTextFieldRow(label);
                break;
            }
            case TEXTAREA: {
                row = EditorFormRow.newTextAreaRow(label);
                break;
            }
            case CHECKBOX: {
                row = EditorFormRow.newCheckBoxRow(label);
                break;
            }
            case COMBOBOX: {
                row = EditorFormRow.newComboBoxRow(label);
                break;
            }
            case LIST: {
                row = EditorFormRow.newListViewRow(label);
            }
        }
        return row;
    }

    public static EditorFormRow<TextField> newTextFieldRow(String label) {
        return new EditorFormRow<TextField>(label, new TextField());
    }

    public static EditorFormRow<TextArea> newTextAreaRow(String label) {
        return new EditorFormRow<TextArea>(label, new TextArea());
    }

    public static EditorFormRow<CheckBox> newCheckBoxRow(String label) {
        return new EditorFormRow<CheckBox>(label, new CheckBox());
    }

    public static <A> EditorFormRow<ComboBox<A>> newComboBoxRow(String label) {
        return new EditorFormRow<ComboBox<A>>(label, new ComboBox());
    }

    public static <A> EditorFormRow<ListView<A>> newListViewRow(String label) {
        return new EditorFormRow<ListView<A>>(label, new ListView());
    }

    private /* synthetic */ void lambda$new$0(StringProperty nameProperty, Observable e) {
        this.label.setText((String)nameProperty.get() + ":");
    }
}

