/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.form;

import com.guigarage.sdk.action.Action;
import com.guigarage.sdk.form.FormRow;
import com.guigarage.sdk.util.MaterialDesignButton;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.layout.HBox;

public class ActionFormRow
implements FormRow {
    private HBox layout = new HBox();

    public ActionFormRow(Action ... actions) {
        this.layout.getStyleClass().add((Object)"form-action-box");
        for (Action action : actions) {
            MaterialDesignButton button = new MaterialDesignButton(action.getTitle());
            button.setOnAction(e -> action.getCallback().call());
            this.layout.getChildren().add((Object)button);
        }
    }

    @Override
    public double getPrefLabelWidth() {
        return -1.0;
    }

    @Override
    public double layoutInParent(double startX, double startY, double width, double labelWidth, double rowSpacing, double columnSpacing) {
        this.layout.relocate(startX, startY);
        double prefHeight = this.layout.prefHeight(width);
        this.layout.resize(width, prefHeight);
        return startY + prefHeight + rowSpacing;
    }

    @Override
    public List<Node> getNodes() {
        return FXCollections.observableArrayList((Object[])new Node[]{this.layout});
    }
}

