/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.footer;

import com.guigarage.sdk.action.Action;
import com.guigarage.sdk.footer.Footer;
import com.guigarage.sdk.util.MaterialDesignButton;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;

public class ActionFooter
extends Footer {
    private ObservableList<Action> actionItems;
    private Map<Action, Node> itemToNode;

    public ActionFooter() {
        this.getStyleClass().add((Object)"action-footer");
        this.itemToNode = new HashMap<Action, Node>();
        this.actionItems = FXCollections.observableArrayList();
        this.actionItems.addListener(c -> {
            while (c.next()) {
                if (c.wasPermutated() || c.wasUpdated()) continue;
                for (Action removed : c.getRemoved()) {
                    Node child = this.itemToNode.remove(removed);
                    this.getChildren().remove((Object)child);
                }
                for (Action added : c.getAddedSubList()) {
                    MaterialDesignButton button = new MaterialDesignButton();
                    button.setText(added.getTitle());
                    button.setOnAction(e -> {
                        if (added.getCallback() != null) {
                            added.getCallback().call();
                        }
                    });
                    if (added.getIcon() != null) {
                        Label iconLabel = new Label();
                        iconLabel.getStyleClass().add((Object)"icon-label");
                        iconLabel.setText(added.getIcon().getText());
                        button.setGraphic((Node)iconLabel);
                    }
                    if (!this.getChildren().isEmpty()) {
                        button.getStyleClass().add((Object)"not-first-button");
                    }
                    this.getChildren().add((Object)button);
                    this.itemToNode.put(added, (Node)button);
                }
            }
        });
    }

    public void addAction(Action action) {
        this.actionItems.add((Object)action);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        double widthPerAction = this.getWidth() / (double)this.getChildren().size();
        double currentX = 0.0;
        for (Node child : this.getChildren()) {
            child.relocate(currentX, 0.0);
            child.resize(widthPerAction, this.getHeight());
            currentX += widthPerAction;
        }
    }
}

