/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.effects;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class RippleEffect {
    private Pane node;
    private Circle circleRipple;
    private Rectangle rippleClip = new Rectangle();
    private Duration rippleDuration = Duration.millis((double)250.0);
    private double lastRippleHeight = 0.0;
    private double lastRippleWidth = 0.0;
    private Color rippleColor = new Color(0.0, 0.0, 0.0, 0.11);

    public RippleEffect(Pane node) {
        this.node = node;
        this.createRippleEffect();
        node.getChildren().add(0, (Object)this.circleRipple);
    }

    private void createRippleEffect() {
        this.circleRipple = new Circle(0.1, (Paint)this.rippleColor);
        this.circleRipple.setOpacity(0.0);
        this.circleRipple.setEffect((Effect)new BoxBlur(3.0, 3.0, 2));
        FadeTransition fadeTransition = new FadeTransition(this.rippleDuration, (Node)this.circleRipple);
        fadeTransition.setInterpolator(Interpolator.EASE_OUT);
        fadeTransition.setFromValue(1.0);
        fadeTransition.setToValue(0.0);
        Timeline scaleRippleTimeline = new Timeline();
        SequentialTransition parallelTransition = new SequentialTransition();
        parallelTransition.getChildren().addAll((Object[])new Animation[]{scaleRippleTimeline, fadeTransition});
        parallelTransition.setOnFinished(event1 -> {
            this.circleRipple.setOpacity(0.0);
            this.circleRipple.setRadius(0.1);
        });
        this.node.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            parallelTransition.stop();
            parallelTransition.getOnFinished().handle(null);
            this.circleRipple.setCenterX(event.getX());
            this.circleRipple.setCenterY(event.getY());
            if (this.node.getWidth() != this.lastRippleWidth || this.node.getHeight() != this.lastRippleHeight) {
                this.lastRippleWidth = this.node.getWidth();
                this.lastRippleHeight = this.node.getHeight();
                this.rippleClip.setWidth(this.lastRippleWidth);
                this.rippleClip.setHeight(this.lastRippleHeight);
                try {
                    this.rippleClip.setArcHeight(((BackgroundFill)this.node.getBackground().getFills().get(0)).getRadii().getTopLeftHorizontalRadius());
                    this.rippleClip.setArcWidth(((BackgroundFill)this.node.getBackground().getFills().get(0)).getRadii().getTopLeftHorizontalRadius());
                    this.circleRipple.setClip((Node)this.rippleClip);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double circleRippleRadius = Math.max(this.node.getHeight(), this.node.getWidth()) * 0.45;
                KeyValue keyValue = new KeyValue((WritableValue)this.circleRipple.radiusProperty(), (Object)circleRippleRadius, Interpolator.EASE_OUT);
                KeyFrame keyFrame = new KeyFrame(this.rippleDuration, new KeyValue[]{keyValue});
                scaleRippleTimeline.getKeyFrames().clear();
                scaleRippleTimeline.getKeyFrames().add((Object)keyFrame);
            }
            parallelTransition.playFromStart();
        });
    }

    public void setRippleColor(Color color) {
        this.circleRipple.setFill((Paint)color);
    }

    public Circle getCircleRipple() {
        return this.circleRipple;
    }
}

