/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.container;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public class WorkbenchView
extends Region {
    private ObjectProperty<Node> headerNode;
    private ObjectProperty<Node> centerNode;
    private ObjectProperty<Node> footerNode;

    public WorkbenchView() {
        this.getStyleClass().add((Object)"workbench-view");
        this.headerNode = new SimpleObjectProperty();
        this.headerNode.addListener(e -> this.update());
        this.centerNode = new SimpleObjectProperty();
        this.centerNode.addListener(e -> this.update());
        this.footerNode = new SimpleObjectProperty();
        this.footerNode.addListener(e -> this.update());
    }

    private void update() {
        this.getChildren().clear();
        if (this.headerNode.get() != null) {
            this.getChildren().add(this.headerNode.get());
        }
        if (this.centerNode.get() != null) {
            this.getChildren().add(this.centerNode.get());
        }
        if (this.footerNode.get() != null) {
            this.getChildren().add(this.footerNode.get());
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        double headerNodePrefHeight = 0.0;
        if (this.headerNode.get() != null) {
            headerNodePrefHeight = ((Node)this.headerNode.get()).prefHeight(-1.0);
            ((Node)this.headerNode.get()).resize(this.getWidth(), headerNodePrefHeight);
            ((Node)this.headerNode.get()).relocate(0.0, 0.0);
        }
        double footerNodePrefHeight = 0.0;
        if (this.footerNode.get() != null) {
            footerNodePrefHeight = ((Node)this.footerNode.get()).prefHeight(-1.0);
            ((Node)this.footerNode.get()).resize(this.getWidth(), footerNodePrefHeight);
            ((Node)this.footerNode.get()).relocate(0.0, this.getHeight() - footerNodePrefHeight);
        }
        if (this.centerNode.get() != null) {
            ((Node)this.centerNode.get()).relocate(0.0, headerNodePrefHeight);
            ((Node)this.centerNode.get()).resize(this.getWidth(), this.getHeight() - headerNodePrefHeight - footerNodePrefHeight);
        }
    }

    public Node getHeaderNode() {
        return (Node)this.headerNode.get();
    }

    public ObjectProperty<Node> headerNodeProperty() {
        return this.headerNode;
    }

    public void setHeaderNode(Node headerNode) {
        this.headerNode.set((Object)headerNode);
    }

    public Node getCenterNode() {
        return (Node)this.centerNode.get();
    }

    public ObjectProperty<Node> centerNodeProperty() {
        return this.centerNode;
    }

    public void setCenterNode(Node centerNode) {
        this.centerNode.set((Object)centerNode);
    }

    public Node getFooterNode() {
        return (Node)this.footerNode.get();
    }

    public ObjectProperty<Node> footerNodeProperty() {
        return this.footerNode;
    }

    public void setFooterNode(Node footerNode) {
        this.footerNode.set((Object)footerNode);
    }

    public static WorkbenchView build() {
        return new WorkbenchView();
    }
}

