/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.container;

import com.guigarage.sdk.action.Action;
import com.guigarage.sdk.container.ContainerToolbar;
import com.guigarage.sdk.footer.InfoFooter;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.shape.Line;

public class BaseContainer
extends Region {
    private ObjectProperty<ContainerToolbar> toolbar;
    private ObjectProperty<Node> centerNode;
    private ObjectProperty<Node> footerNode;
    private Line footerSeperator;

    public BaseContainer() {
        this.getStyleClass().add((Object)"base-container");
        this.footerSeperator = new Line();
        this.footerSeperator.getStyleClass().add((Object)"base-container-footer-seperator");
        this.toolbar = new SimpleObjectProperty();
        this.toolbar.addListener(e -> this.update());
        this.centerNode = new SimpleObjectProperty();
        this.centerNode.addListener(e -> this.update());
        this.footerNode = new SimpleObjectProperty();
        this.footerNode.addListener(e -> this.update());
        this.toolbar.setValue((Object)new ContainerToolbar());
    }

    private void update() {
        this.getChildren().clear();
        if (this.toolbar.get() != null) {
            this.getChildren().add(this.toolbar.get());
        }
        if (this.centerNode.get() != null) {
            this.getChildren().add(this.centerNode.get());
        }
        if (this.footerNode.get() != null) {
            this.getChildren().add(this.footerNode.get());
        }
    }

    protected void layoutChildren() {
        double toolbarPrefHeight = 0.0;
        if (this.toolbar.get() != null) {
            toolbarPrefHeight = ((ContainerToolbar)((Object)this.toolbar.get())).prefHeight(-1.0);
            double toolbarNodePrefWidth = ((ContainerToolbar)((Object)this.toolbar.get())).prefWidth(-1.0);
            ((ContainerToolbar)((Object)this.toolbar.get())).resize(this.getWidth(), toolbarPrefHeight);
            ((ContainerToolbar)((Object)this.toolbar.get())).relocate(0.0, 0.0);
        }
        double footerNodePrefHeight = 0.0;
        if (this.footerNode.get() != null) {
            footerNodePrefHeight = ((Node)this.footerNode.get()).prefHeight(-1.0);
            double footerNodePrefWidth = ((Node)this.footerNode.get()).prefWidth(-1.0);
            ((Node)this.footerNode.get()).resize(this.getWidth() - this.getPadding().getLeft() - this.getPadding().getRight(), footerNodePrefHeight);
            ((Node)this.footerNode.get()).relocate(this.getPadding().getLeft(), this.getHeight() - footerNodePrefHeight);
            if (!this.getChildren().contains((Object)this.footerSeperator)) {
                this.getChildren().add((Object)this.footerSeperator);
            }
            this.footerSeperator.setStartX(6.0);
            this.footerSeperator.setStartY(this.getHeight() - footerNodePrefHeight);
            this.footerSeperator.setEndX(this.getWidth() - 6.0);
            this.footerSeperator.setEndY(this.getHeight() - footerNodePrefHeight);
        } else {
            this.getChildren().remove((Object)this.footerSeperator);
        }
        if (this.centerNode.get() != null) {
            ((Node)this.centerNode.get()).relocate(this.getPadding().getLeft(), toolbarPrefHeight + this.getPadding().getTop());
            ((Node)this.centerNode.get()).resize(this.getWidth() - this.getPadding().getLeft() - this.getPadding().getTop(), this.getHeight() - footerNodePrefHeight - toolbarPrefHeight - this.getPadding().getTop() - this.getPadding().getBottom());
        }
    }

    public ContainerToolbar getToolbar() {
        return (ContainerToolbar)((Object)this.toolbar.get());
    }

    public ObjectProperty<ContainerToolbar> toolbarProperty() {
        return this.toolbar;
    }

    public void setToolbar(ContainerToolbar toolbar) {
        this.toolbar.set((Object)toolbar);
    }

    public Node getCenterNode() {
        return (Node)this.centerNode.get();
    }

    public ObjectProperty<Node> centerNodeProperty() {
        return this.centerNode;
    }

    public void setCenterNode(Node centerNode) {
        this.centerNode.set((Object)centerNode);
    }

    public Node getFooterNode() {
        return (Node)this.footerNode.get();
    }

    public ObjectProperty<Node> footerNodeProperty() {
        return this.footerNode;
    }

    public void setFooterNode(Node footerNode) {
        this.footerNode.set((Object)footerNode);
    }

    public static BaseContainer build() {
        return new BaseContainer();
    }

    public BaseContainer withTitle(String title) {
        this.getToolbar().setTitle(title);
        return this;
    }

    public BaseContainer withContent(Node node) {
        this.setCenterNode(node);
        return this;
    }

    public BaseContainer withToolbarItem(Action action) {
        this.getToolbar().addAction(action);
        return this;
    }

    public BaseContainer withFooter(Node node) {
        this.setFooterNode(node);
        return this;
    }

    public BaseContainer withInfoFooter(String text) {
        this.setFooterNode((Node)new InfoFooter().withText(text));
        return this;
    }
}

