/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.chat;

import com.guigarage.sdk.chat.ChatMessage;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class ChatBubble
extends Region {
    private Rectangle mainBubble;
    private Label chatText;
    private Rectangle mySpeakerSign;
    private Rectangle oppositeSpeakerSign;
    double chatInsets = 12.0;
    private PseudoClass mePseudoClass = PseudoClass.getPseudoClass((String)"me");
    private PseudoClass oppositePseudoClass = PseudoClass.getPseudoClass((String)"opposite");
    private ObjectProperty<ChatMessage> message;

    public ChatBubble() {
        this.getStyleClass().addAll((Object[])new String[]{"chat-bubble-wrapper"});
        this.message = new SimpleObjectProperty();
        this.mainBubble = new Rectangle();
        this.mainBubble.getStyleClass().addAll((Object[])new String[]{"chat-bubble", "chat-bubble-rect"});
        this.mainBubble.setManaged(false);
        this.mySpeakerSign = new Rectangle();
        this.mySpeakerSign.getStyleClass().add((Object)"chat-bubble");
        this.mySpeakerSign.setRotate(45.0);
        this.mySpeakerSign.setManaged(false);
        this.oppositeSpeakerSign = new Rectangle();
        this.oppositeSpeakerSign.getStyleClass().add((Object)"chat-bubble");
        this.oppositeSpeakerSign.setRotate(45.0);
        this.oppositeSpeakerSign.setManaged(false);
        this.chatText = new Label();
        this.chatText.setWrapText(true);
        this.chatText.getStyleClass().add((Object)"chat-text");
        this.getChildren().addAll((Object[])new Node[]{this.mainBubble, this.mySpeakerSign, this.oppositeSpeakerSign, this.chatText});
        InvalidationListener sendByMeListener = e -> {
            if (((ChatMessage)this.message.get()).sendByMeProperty().get()) {
                this.setChatPseudoClass(this.mePseudoClass, true);
                this.setChatPseudoClass(this.oppositePseudoClass, false);
            } else {
                this.setChatPseudoClass(this.mePseudoClass, false);
                this.setChatPseudoClass(this.oppositePseudoClass, true);
            }
        };
        this.message.addListener((obs, oldV, newV) -> {
            this.chatText.textProperty().unbind();
            this.mySpeakerSign.visibleProperty().unbind();
            this.oppositeSpeakerSign.visibleProperty().unbind();
            if (oldV != null) {
                oldV.sendByMeProperty().removeListener(sendByMeListener);
            }
            if (newV != null) {
                newV.sendByMeProperty().addListener(sendByMeListener);
                sendByMeListener.invalidated((Observable)newV.sendByMeProperty());
                this.chatText.textProperty().bind((ObservableValue)newV.messageProperty());
                this.mySpeakerSign.visibleProperty().bind((ObservableValue)newV.sendByMeProperty());
                this.oppositeSpeakerSign.visibleProperty().bind((ObservableValue)newV.sendByMeProperty().not());
            }
        });
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.setMinWidth(0.0);
    }

    private void setChatPseudoClass(PseudoClass cls, boolean value) {
        this.mainBubble.pseudoClassStateChanged(cls, value);
        this.mySpeakerSign.pseudoClassStateChanged(cls, value);
        this.oppositeSpeakerSign.pseudoClassStateChanged(cls, value);
    }

    protected void layoutChildren() {
        this.mainBubble.setX(0.0);
        this.mainBubble.setY(0.0);
        this.mainBubble.setWidth(this.getWidth());
        this.mainBubble.setHeight(this.getHeight() - 24.0);
        this.mySpeakerSign.setX(this.mainBubble.getWidth() - 24.0 - 18.0);
        this.mySpeakerSign.setY(this.mainBubble.getHeight() - 12.0 - 4.0);
        this.mySpeakerSign.setWidth(24.0);
        this.mySpeakerSign.setHeight(24.0);
        this.oppositeSpeakerSign.setX(18.0);
        this.oppositeSpeakerSign.setY(this.mainBubble.getHeight() - 12.0 - 4.0);
        this.oppositeSpeakerSign.setWidth(24.0);
        this.oppositeSpeakerSign.setHeight(24.0);
        this.chatText.relocate(this.mainBubble.getX() + this.chatInsets, this.mainBubble.getY() + this.chatInsets);
        this.chatText.resize(this.mainBubble.getWidth() - this.chatInsets - this.chatInsets, this.mainBubble.getHeight() - this.chatInsets - this.chatInsets);
    }

    protected double computePrefHeight(double width) {
        double prefHeight = this.chatText.prefHeight(width - this.chatInsets - this.chatInsets) + this.chatInsets + this.chatInsets + 24.0;
        return prefHeight;
    }

    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    public void setMessage(ChatMessage message) {
        this.message.setValue((Object)message);
    }
}

