/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.animations;

import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.Transition;
import javafx.animation.TranslateTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class MaximizeToTransition {
    public static Transition create(Duration duration, Region node, Region parentNode) {
        ScaleTransition transition = new ScaleTransition(duration, (Node)node);
        transition.setFromX(node.getScaleX());
        transition.setFromY(node.getScaleY());
        transition.toXProperty().bind((ObservableValue)parentNode.widthProperty().divide((ObservableNumberValue)node.widthProperty()));
        transition.toYProperty().bind((ObservableValue)parentNode.heightProperty().divide((ObservableNumberValue)node.heightProperty()));
        TranslateTransition translateTransition = new TranslateTransition(duration, (Node)node);
        translateTransition.setFromX(node.getTranslateX());
        translateTransition.setFromY(node.getTranslateY());
        DoubleBinding translateXBinding = Bindings.createDoubleBinding(() -> {
            Point2D topLeft = node.localToScene(0.0, 0.0);
            Point2D topLeftParent = parentNode.localToScene(0.0, 0.0);
            return topLeftParent.getX() - topLeft.getX();
        }, (Observable[])new Observable[]{node.layoutBoundsProperty(), parentNode.layoutBoundsProperty()});
        DoubleBinding translateYBinding = Bindings.createDoubleBinding(() -> {
            Point2D topLeft = node.localToScene(0.0, 0.0);
            Point2D topLeftParent = parentNode.localToScene(0.0, 0.0);
            return topLeftParent.getY() - topLeft.getY();
        }, (Observable[])new Observable[]{node.layoutBoundsProperty(), parentNode.layoutBoundsProperty()});
        translateTransition.toYProperty().bind((ObservableValue)translateYBinding);
        ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{transition, translateTransition});
        return parallelTransition;
    }
}

