/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk.actionbutton;

import com.guigarage.sdk.action.Action;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.shape.Rectangle;

public class GlobalActionButton
extends HBox {
    private ObservableList<Action> actions;
    private Map<Action, Node> itemToNode;

    public GlobalActionButton() {
        this.getStyleClass().add((Object)"global-action-button");
        this.actions = FXCollections.observableArrayList();
        this.itemToNode = new HashMap<Action, Node>();
        this.actions.addListener(c -> {
            while (c.next()) {
                if (c.wasPermutated() || c.wasUpdated()) continue;
                for (Action removed : c.getRemoved()) {
                    Node child = this.itemToNode.remove(removed);
                    this.getChildren().remove((Object)child);
                }
                for (Action added : c.getAddedSubList()) {
                    Button button = new Button();
                    button.setText(added.getIcon().getText());
                    button.setOnMouseEntered(e -> {
                        button.setScaleX(1.1);
                        button.setScaleY(1.1);
                    });
                    button.setOnMouseExited(e -> {
                        button.setScaleX(1.0);
                        button.setScaleY(1.0);
                    });
                    button.setOnAction(e -> {
                        if (added.getCallback() != null) {
                            added.getCallback().call();
                        }
                    });
                    this.getChildren().add((Object)button);
                    this.itemToNode.put(added, (Node)button);
                }
            }
        });
        Rectangle background = new Rectangle();
        background.getStyleClass().add((Object)"global-action-button-background");
        background.setManaged(false);
        background.setX(0.0);
        background.setY(0.0);
        background.widthProperty().bind((ObservableValue)this.widthProperty());
        background.heightProperty().bind((ObservableValue)this.heightProperty());
        background.arcWidthProperty().bind((ObservableValue)this.heightProperty());
        background.arcHeightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)background);
        this.minWidth(Double.NEGATIVE_INFINITY);
        this.maxWidth(Double.NEGATIVE_INFINITY);
        this.minHeight(Double.NEGATIVE_INFINITY);
        this.maxHeight(Double.NEGATIVE_INFINITY);
    }

    protected double computePrefWidth(double height) {
        if (this.actions.size() == 0) {
            return 0.0;
        }
        if (this.actions.size() == 1) {
            return Math.max(super.computePrefWidth(-1.0), super.computePrefHeight(-1.0));
        }
        return super.computePrefWidth(-1.0);
    }

    protected double computePrefHeight(double width) {
        if (this.actions.size() == 0) {
            return 0.0;
        }
        if (this.actions.size() == 1) {
            return Math.max(super.computePrefWidth(-1.0), super.computePrefHeight(-1.0));
        }
        return super.computePrefHeight(-1.0);
    }

    public ObservableList<Action> getActions() {
        return this.actions;
    }
}

