/*
 * Decompiled with CFR 0.152.
 */
package com.guigarage.sdk;

import com.guigarage.sdk.ApplicationStarter;
import com.guigarage.sdk.action.Action;
import com.guigarage.sdk.actionbutton.GlobalActionButton;
import com.guigarage.sdk.container.Workbench;
import com.guigarage.sdk.menu.MenuPane;
import com.guigarage.sdk.toolbar.ApplicationToolbar;
import com.guigarage.sdk.util.Callback;
import com.guigarage.sdk.util.Media;
import com.guigarage.sdk.util.SliderPane;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Application
extends VBox {
    private ObservableList<String> stylesheets;
    private ApplicationToolbar toolbar;
    private Workbench workbench;
    private SliderPane menuSlider;
    private ObjectProperty<Color> baseColor;
    private MenuPane menuPane;
    private ObjectProperty<Stage> stage = new SimpleObjectProperty();
    private ObjectProperty<Scene> scene = new SimpleObjectProperty();
    private ObjectProperty<Callback> stopCallback = new SimpleObjectProperty();
    private Lock javaFxStarterLock = new ReentrantLock();
    private Condition javaFXStarterCondition = this.javaFxStarterLock.newCondition();
    private GlobalActionButton globalActionButton;

    public Application() {
        this.javaFxStarterLock.lock();
        try {
            Executors.newSingleThreadExecutor().execute(() -> ApplicationStarter.run(s -> {
                this.javaFxStarterLock.lock();
                try {
                    this.stage.setValue(s);
                    this.initApplication();
                    this.javaFXStarterCondition.signalAll();
                }
                finally {
                    this.javaFxStarterLock.unlock();
                }
            }, () -> {
                if (this.stopCallback.get() != null) {
                    ((Callback)this.stopCallback.get()).call();
                }
            }));
            try {
                this.javaFXStarterCondition.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            this.javaFxStarterLock.unlock();
        }
    }

    private void initApplication() {
        this.baseColor = new SimpleObjectProperty();
        this.stylesheets = FXCollections.observableArrayList();
        this.stylesheets.addListener(c -> {
            Scene myScene = (Scene)this.scene.get();
            if (myScene != null) {
                myScene.getStylesheets().clear();
                myScene.getStylesheets().addAll(this.stylesheets);
            }
        });
        this.workbench = new Workbench();
        this.menuSlider = new SliderPane();
        this.menuSlider.setPinned(false);
        this.menuPane = new MenuPane();
        this.menuPane.setGlobalActionCallback(this.menuSlider::hidePopover);
        this.menuSlider.setPopover((Node)this.menuPane);
        this.menuSlider.setContent((Node)this.workbench);
        this.toolbar = new ApplicationToolbar();
        this.toolbar.setMenuButtonCallback(() -> {
            if (this.menuSlider.isPopoverVisible()) {
                this.menuSlider.hidePopover();
            } else {
                this.menuSlider.showPopover();
            }
        });
        VBox.setVgrow((Node)this.toolbar, (Priority)Priority.NEVER);
        VBox menuBox = new VBox();
        menuBox.setPadding(new Insets(6.0));
        VBox.setVgrow((Node)this.menuSlider, (Priority)Priority.ALWAYS);
        this.setFillWidth(true);
        this.getChildren().addAll((Object[])new Node[]{this.toolbar, this.menuSlider});
        this.baseColor.addListener(e -> {
            if (this.baseColor.get() != null) {
                this.setStyle("-fx-basic-color: rgba(" + (int)(((Color)this.baseColor.get()).getRed() * 255.0) + ", " + (int)(((Color)this.baseColor.get()).getGreen() * 255.0) + ", " + (int)(((Color)this.baseColor.get()).getBlue() * 255.0) + ", " + (int)(((Color)this.baseColor.get()).getOpacity() * 255.0) + ");");
            }
        });
        this.globalActionButton = new GlobalActionButton();
        this.globalActionButton.setManaged(false);
        this.globalActionButton.disableProperty().bind((ObservableValue)this.menuSlider.popoverVisibleProperty());
        this.getChildren().add((Object)this.globalActionButton);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.globalActionButton.toFront();
        double actionButtonPrefWidth = this.globalActionButton.prefWidth(-1.0);
        double actionButtonPrefHeight = this.globalActionButton.prefHeight(-1.0);
        this.globalActionButton.resize(actionButtonPrefWidth, actionButtonPrefHeight);
        if (this.toolbar.isLarge()) {
            this.globalActionButton.relocate(this.getWidth() - this.getPadding().getRight() - 48.0 - actionButtonPrefWidth, this.toolbar.getHeight() - actionButtonPrefHeight / 2.0);
        } else {
            this.globalActionButton.relocate(this.getWidth() - this.getPadding().getRight() - 48.0 - actionButtonPrefWidth, this.toolbar.getHeight() + 48.0);
        }
    }

    public void removeGlobalAction(Action action) {
        this.globalActionButton.getActions().remove((Object)action);
    }

    public void clearGlobalActions() {
        this.globalActionButton.getActions().clear();
    }

    public void addGlobalAction(Action action) {
        this.globalActionButton.getActions().add((Object)action);
    }

    public void setTitle(String title) {
        this.toolbar.setTitle(title);
    }

    public void addToolbarItem(Action action) {
        this.toolbar.addAction(action);
    }

    public void setWorkbench(Node view) {
        this.workbench.setCurrentView(view);
    }

    public void addStylesheet(String stylesheet) {
        this.stylesheets.add((Object)stylesheet);
    }

    public void setBaseColor(Color color) {
        this.baseColor.setValue((Object)color);
    }

    public void addMenuEntry(Action action) {
        this.menuPane.add(action);
    }

    public void setMenuHeader(Node menuHeader) {
        this.menuPane.setHeader(menuHeader);
    }

    public void setMenuFooter(Node menuFooter) {
        this.menuPane.setFooter(menuFooter);
    }

    public void setMediaAsMenuHeader(Media media) {
        this.menuPane.setHeader(media);
    }

    public void setMenuFooter(Action action) {
        this.menuPane.setActionAsFooter(action);
    }

    public void setMenuButtonVisible(boolean visible) {
        this.toolbar.setMenuButtonVisible(visible);
    }

    public void setToolbarLarge(boolean large) {
        this.toolbar.setLarge(large);
    }

    public boolean isToolbarLarge() {
        return this.toolbar.isLarge();
    }

    public void animateToolbarToLargeVersion() {
        this.toolbar.animateToLargeVersion();
    }

    public void animateToolbarToSmallVersion() {
        this.toolbar.animateToSmallVersion();
    }

    public void setToolbarBackgroundImage(Image image) {
        this.toolbar.setBackgroundImage(image);
    }

    public void setToolbarBackgroundImage(String path) {
        this.toolbar.setBackgroundImage(path);
    }

    public void show() {
        Runnable r = () -> {
            Scene myScene = new Scene((Parent)this);
            this.scene.setValue((Object)myScene);
            this.addStylesheet(ApplicationStarter.class.getResource("fonts.css").toExternalForm());
            this.addStylesheet(ApplicationStarter.class.getResource("default-style.css").toExternalForm());
            ((Stage)this.stage.get()).setScene((Scene)this.scene.get());
            ((Stage)this.stage.get()).show();
        };
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)r);
        } else {
            r.run();
        }
    }

    public Callback getStopCallback() {
        return (Callback)this.stopCallback.get();
    }

    public ObjectProperty<Callback> stopCallbackProperty() {
        return this.stopCallback;
    }

    public void setStopCallback(Callback stopCallback) {
        this.stopCallback.set((Object)stopCallback);
    }

    public Image getToolbarBackgroundImage() {
        return this.toolbar.getBackgroundImage();
    }

    public ObjectProperty<Stage> stageProperty() {
        return this.stage;
    }
}

