/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422.decorators;

import java.time.Instant;
import java.util.Optional;
import org.mbari.util.NumberUtilities;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.Decorator;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.commands.RS422VideoCommands;
import org.mbari.vcr4j.rs422.commands.RequestUserbitsAsTimeCmd;
import rx.Observable;
import rx.Subscriber;
import rx.subjects.Subject;

public class UserbitsAsTimeDecorator
implements Decorator {
    private final Observable<VideoIndex> indexObservable;
    private final Subscriber<VideoCommand> commandSubscriber;

    public UserbitsAsTimeDecorator(VCRVideoIO io) {
        final Subject commandSubject = io.getCommandSubject();
        this.commandSubscriber = new Subscriber<VideoCommand>(){

            public void onCompleted() {
            }

            public void onError(Throwable throwable) {
            }

            public void onNext(VideoCommand videoCommand) {
                commandSubject.onNext((Object)VideoCommands.REQUEST_TIMECODE);
                commandSubject.onNext((Object)RS422VideoCommands.REQUEST_USERBITS);
            }
        };
        commandSubject.filter(vc -> vc == RequestUserbitsAsTimeCmd.COMMAND || vc == VideoCommands.REQUEST_TIMESTAMP).subscribe(this.commandSubscriber);
        this.indexObservable = Observable.combineLatest((Observable)io.getIndexObservable(), io.getUserbitsObservable(), (videoIndex, userbits) -> new VideoIndex(Optional.of(UserbitsAsTimeDecorator.userbitsAsInstant(userbits.getUserbits())), videoIndex.getElapsedTime(), videoIndex.getTimecode())).distinctUntilChanged();
    }

    public static Instant userbitsAsInstant(byte[] userbits) {
        int epochSeconds = NumberUtilities.toInt((byte[])userbits, (boolean)true);
        return Instant.ofEpochSecond(epochSeconds);
    }

    public Observable<VideoIndex> getIndexObservable() {
        return this.indexObservable;
    }

    public void unsubscribe() {
        this.commandSubscriber.unsubscribe();
    }
}

