/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422.decorators;

import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.decorators.LoggingDecorator;
import org.mbari.vcr4j.rs422.RS422Error;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.RS422Timecode;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.decorators.RS422TimecodeAsString;
import rx.Subscriber;

public class RS422LoggingDecorator
extends LoggingDecorator<RS422State, RS422Error> {
    Subscriber<RS422Timecode> timecodeSubscriber = new Subscriber<RS422Timecode>(){

        public void onCompleted() {
            RS422LoggingDecorator.this.log.debug("Timecode observable is closed");
        }

        public void onError(Throwable throwable) {
            RS422LoggingDecorator.this.log.debug("An error occurred in the timecode observable", throwable);
        }

        public void onNext(RS422Timecode timecode) {
            if (RS422LoggingDecorator.this.log.isDebugEnabled()) {
                RS422LoggingDecorator.this.log.debug("Received: " + new RS422TimecodeAsString(timecode).toString());
            }
        }
    };

    public RS422LoggingDecorator(VCRVideoIO io) {
        super((VideoIO)io);
        io.getTimecodeObservable().subscribe(this.timecodeSubscriber);
    }

    public void unsubscribe() {
        super.unsubscribe();
        this.timecodeSubscriber.unsubscribe();
    }
}

