/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422;

import java.util.Arrays;
import org.mbari.vcr4j.util.Preconditions;

public class RS422Userbits {
    public static final byte[] LTC_USERBITS = new byte[]{116, 5};
    public static final byte[] LTC_USERBITS_HOLD = new byte[]{116, 21};
    public static final byte[] VTC_USERBITS = new byte[]{116, 7};
    public static final byte[] VTC_USERBITS_HOLD = new byte[]{116, 23};
    private final byte[] userbits;

    public RS422Userbits(byte[] userbits) {
        Preconditions.checkArgument((userbits != null ? 1 : 0) != 0, (String)"userbits arg can not be null");
        this.userbits = userbits;
    }

    public static boolean isUserbitsReply(byte[] cmd) {
        return Arrays.equals(cmd, LTC_USERBITS) || Arrays.equals(cmd, VTC_USERBITS);
    }

    public static boolean isUserbitsHoldReply(byte[] cmd) {
        return Arrays.equals(cmd, LTC_USERBITS_HOLD) || Arrays.equals(cmd, VTC_USERBITS_HOLD);
    }

    public byte[] getUserbits() {
        return this.userbits;
    }

    public int hashCode() {
        return Arrays.hashCode(this.userbits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RS422Userbits that = (RS422Userbits)o;
        return Arrays.equals(this.userbits, that.userbits);
    }
}

