/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422;

import java.util.Arrays;
import org.mbari.util.NumberUtilities;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.rs422.RS422Error;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.RS422Timecode;
import org.mbari.vcr4j.rs422.RS422Userbits;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class RS422ResponseParser {
    public static final byte[] ACK = new byte[]{16, 1};
    public static final byte[] NACK = new byte[]{17, 18};
    private final Subject<RS422Error, RS422Error> errorObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<RS422State, RS422State> statusObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<RS422Timecode, RS422Timecode> timecodeObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<RS422Userbits, RS422Userbits> userbitsObservable = new SerializedSubject((Subject)PublishSubject.create());

    public static byte calculateChecksum(byte[] command) {
        int temp = 0;
        for (int i = 0; i < command.length; ++i) {
            temp += command[i];
        }
        return (byte)temp;
    }

    public void update(byte[] command, byte[] cmd, byte[] data, byte[] checksum) {
        this.update(command, cmd, data, checksum);
    }

    public void update(byte[] command, byte[] cmd, byte[] data, byte[] checksum, VideoCommand videoCommand) {
        byte commandChecksum = RS422ResponseParser.calculateChecksum(command);
        if (!this.isChecksumOK(cmd, data, checksum)) {
            this.errorObservable.onNext((Object)new RS422Error(4, videoCommand));
        } else if (RS422ResponseParser.isAck(cmd)) {
            this.errorObservable.onNext((Object)new RS422Error(0, videoCommand));
        } else if (RS422Timecode.isTimecodeReply(cmd)) {
            this.timecodeObservable.onNext((Object)new RS422Timecode(data));
        } else if (RS422Userbits.isUserbitsReply(cmd)) {
            this.userbitsObservable.onNext((Object)new RS422Userbits(data));
        } else if (RS422State.isStatusReply(cmd)) {
            this.statusObservable.onNext((Object)new RS422State(NumberUtilities.toLong((byte[])data)));
        } else if (RS422ResponseParser.isNack(cmd)) {
            byte nackData = data[0];
            this.errorObservable.onNext((Object)new RS422Error(nackData, videoCommand));
        }
    }

    public static boolean isAck(byte[] cmd) {
        return Arrays.equals(cmd, ACK);
    }

    private boolean isChecksumOK(byte[] cmd, byte[] data, byte[] checksum) {
        boolean OK;
        if (cmd == null) {
            OK = false;
        } else {
            byte checksum2;
            int i;
            byte[] cmdBlock = data == null || data.length == 0 ? new byte[cmd.length] : new byte[cmd.length + data.length];
            for (i = 0; i < cmd.length; ++i) {
                cmdBlock[i] = cmd[i];
            }
            if (data != null && data.length > 0) {
                for (i = 2; i < cmdBlock.length; ++i) {
                    cmdBlock[i] = data[i - 2];
                }
            }
            OK = checksum[0] == (checksum2 = RS422ResponseParser.calculateChecksum(cmdBlock));
        }
        return OK;
    }

    public static boolean isNack(byte[] cmd) {
        return Arrays.equals(cmd, NACK);
    }

    public Subject<RS422Error, RS422Error> getErrorObservable() {
        return this.errorObservable;
    }

    public Subject<RS422State, RS422State> getStatusObservable() {
        return this.statusObservable;
    }

    public Subject<RS422Timecode, RS422Timecode> getTimecodeObservable() {
        return this.timecodeObservable;
    }

    public Subject<RS422Userbits, RS422Userbits> getUserbitsObservable() {
        return this.userbitsObservable;
    }
}

