/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rs422;

import org.mbari.util.NumberUtilities;
import org.mbari.vcr4j.VideoCommand;
import org.slf4j.Logger;

public class LoggerHelper {
    private final Logger log;

    public LoggerHelper(Logger log) {
        this.log = log;
    }

    public void logCommand(byte[] bytes, VideoCommand videoCommand) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("[0x" + NumberUtilities.toHexString((byte[])bytes) + "] >>> VCR (" + videoCommand.getName() + ")");
        }
    }

    public void logResponse(byte[] cmd, byte[] data, byte[] checksum) {
        if (this.log.isDebugEnabled()) {
            int dataLength = data == null ? 0 : data.length;
            byte[] c = new byte[cmd.length + dataLength + 1];
            System.arraycopy(cmd, 0, c, 0, cmd.length);
            if (data != null) {
                System.arraycopy(data, 0, c, cmd.length, data.length);
            }
            c[c.length - 1] = checksum[0];
            this.log.debug("[0x" + NumberUtilities.toHexString((byte[])c) + "] <<< VCR");
        }
    }
}

