/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangeWatchDog<R> {
    private final long durationNanos;
    private final File file;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Thread thread;
    private final Function<File, R> fn;
    private final SettableFuture<R> future;
    private final WatchEvent.Kind<Path>[] kinds;

    public FileChangeWatchDog(File file, long durationSeconds, Function<File, R> fn, WatchEvent.Kind<Path> ... kinds) {
        Preconditions.checkArgument((durationSeconds > 0L ? 1 : 0) != 0, (Object)"durationSeconds must be greater than 0");
        this.file = file;
        this.durationNanos = durationSeconds * 1000000000L;
        this.fn = fn;
        this.future = SettableFuture.create();
        this.kinds = kinds;
        this.thread = new Thread((Runnable)new WatchRunnable(), this.getClass().getSimpleName() + "-" + System.currentTimeMillis());
        this.thread.setDaemon(true);
    }

    public ListenableFuture<R> getFuture() {
        return this.future;
    }

    public void start() {
        this.thread.start();
    }

    private class WatchRunnable
    implements Runnable {
        long elapsed = 0L;
        long start;

        private WatchRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.start = System.nanoTime();
            Path path = FileChangeWatchDog.this.file.getParentFile().toPath();
            WatchService watchService = null;
            boolean didComplete = false;
            try {
                watchService = path.getFileSystem().newWatchService();
                WatchKey registrationKey = path.register(watchService, FileChangeWatchDog.this.kinds);
                while (this.elapsed < FileChangeWatchDog.this.durationNanos) {
                    WatchKey key = watchService.take();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path changedPath;
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW || !(changedPath = (Path)event.context()).toFile().getName().equals(FileChangeWatchDog.this.file.getName())) continue;
                        FileChangeWatchDog.this.future.set(FileChangeWatchDog.this.fn.apply((Object)changedPath.toFile()));
                        didComplete = true;
                        break;
                    }
                    this.elapsed = System.nanoTime() - this.start;
                    boolean isKeyStillValid = key.reset();
                    if (isKeyStillValid) continue;
                    break;
                }
            }
            catch (Exception e) {
                FileChangeWatchDog.this.future.setException((Throwable)e);
            }
            finally {
                if (watchService != null) {
                    try {
                        watchService.close();
                    }
                    catch (IOException e) {
                        FileChangeWatchDog.this.log.warn("An Exception was thrown while closing a WatchService", (Throwable)e);
                    }
                }
            }
            if (!didComplete) {
                FileChangeWatchDog.this.future.setException((Throwable)new RuntimeException("Failed to execute function via FileChangeWatchDog"));
            }
        }
    }
}

