/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.util;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveAppBeacon {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int MIN_PORT_NUMBER = 1;
    public static final int MAX_PORT_NUMBER = 49151;
    private ServerSocket serverSocket;
    private final Thread beaconThread;
    private volatile boolean ok = true;
    private final String pingMessage;

    public ActiveAppBeacon(Collection<Integer> ports, final String pingMessage) {
        this.pingMessage = pingMessage;
        for (Integer p : ports) {
            if (!ActiveAppBeacon.available(p)) continue;
            try {
                this.serverSocket = new ServerSocket(p);
                break;
            }
            catch (IOException e) {
                this.log.info("Unable to open port {}", (Object)p);
            }
        }
        if (this.serverSocket == null) {
            this.ok = false;
            Joiner joiner = Joiner.on((String)", ").skipNulls();
            String portMsg = joiner.join(ports);
            this.beaconThread = null;
            this.log.warn("Failed to activate a ServerSocket for ActiveAppBeacon on any of the following ports: " + portMsg);
        } else {
            final ServerSocket s = this.serverSocket;
            this.beaconThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (ActiveAppBeacon.this.ok) {
                        try {
                            Socket socket = s.accept();
                            OutputStreamWriter writer = new OutputStreamWriter(socket.getOutputStream());
                            writer.write(pingMessage + "\n");
                            ((Writer)writer).flush();
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
            this.beaconThread.setDaemon(true);
            this.beaconThread.start();
        }
    }

    public void kill() {
        this.ok = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                this.log.debug("The beacon's ServerSocket threw an exception while killing the beacon. Nothing to see here. Just letting you know");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        if (port < 1 || port > 49151) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public boolean isAlive() {
        return this.ok;
    }
}

