/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.tree;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.knowledgebase.Concept;
import vars.shared.ui.StringTransferable;
import vars.shared.ui.UIDecorator;

public class JTreeDragAndDropDecorator
implements UIDecorator {
    private final JTree tree;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DragGestureListener dragGestureListener;
    private final DragSource dragSource;
    private final DragSourceListener dragSourceListener;

    public JTreeDragAndDropDecorator(JTree tree) {
        this.tree = tree;
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragGestureListener = new DGListener();
        this.dragSourceListener = new DSListener();
        this.dragSource.createDefaultDragGestureRecognizer(tree, 1, this.dragGestureListener);
    }

    class DSListener
    implements DragSourceListener {
        DSListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int myaction = e.getDropAction();
            if ((myaction & 1) != 0) {
                context.setCursor(DragSource.DefaultCopyDrop);
            } else {
                context.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    class DGListener
    implements DragGestureListener {
        DGListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            block4: {
                if ((e.getDragAction() & 1) == 0) {
                    return;
                }
                TreePath treePath = JTreeDragAndDropDecorator.this.tree.getSelectionPath();
                if (treePath != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    Concept concept = (Concept)node.getUserObject();
                    StringTransferable transferable = new StringTransferable(concept.getPrimaryConceptName().getName());
                    try {
                        e.startDrag(DragSource.DefaultCopyNoDrop, transferable, JTreeDragAndDropDecorator.this.dragSourceListener);
                    }
                    catch (InvalidDnDOperationException idoe) {
                        if (!JTreeDragAndDropDecorator.this.log.isDebugEnabled()) break block4;
                        JTreeDragAndDropDecorator.this.log.debug("Failed drag and drop", (Throwable)idoe);
                    }
                }
            }
        }
    }
}

