/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.tree;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.EventBus;
import org.mbari.swing.JImageUrlFrame;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.Media;
import vars.shared.ui.GlobalStateLookup;
import vars.shared.ui.tree.ConceptTreeModel;
import vars.shared.ui.tree.ConceptTreeNode;

public class ConceptTreePopupMenu
extends JPopupMenu {
    JMenuItem expandMenuItem;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;
    JMenuItem showMediaItem;
    private final JTree tree;

    public ConceptTreePopupMenu(JTree tree, KnowledgebaseDAOFactory knowledgebaseDAOFactory) {
        this.tree = tree;
        this.knowledgebaseDAOFactory = knowledgebaseDAOFactory;
        if (!(tree.getModel() instanceof ConceptTreeModel)) {
            throw new IllegalArgumentException("The JTree you provided does not use a ConceptTreeModel");
        }
        this.showMediaItem = new JMenuItem("Show Image", 73);
        this.showMediaItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConceptTreePopupMenu.this.showPrimaryImage();
            }
        });
        this.add(this.showMediaItem);
        this.expandMenuItem = new JMenuItem("Expand", 69);
        this.expandMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConceptTreePopupMenu.this.expandNode();
            }
        });
        this.add(this.expandMenuItem);
        JMenuItem collapseMenuItem = new JMenuItem("Collapse", 67);
        collapseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConceptTreePopupMenu.this.collapseNode();
            }
        });
        this.add(collapseMenuItem);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectionPath = ConceptTreePopupMenu.this.tree.getSelectionPath();
                if (selectionPath != null) {
                    ConceptTreeNode node = (ConceptTreeNode)selectionPath.getLastPathComponent();
                    Concept concept = (Concept)node.getUserObject();
                    boolean enable = concept != null && concept.getConceptMetadata().getPrimaryImage() != null;
                    ConceptTreePopupMenu.this.showMediaItem.setEnabled(enable);
                }
            }
        });
    }

    private void collapseNode() {
        this.togglePath(this.tree.getSelectionPath(), false);
    }

    private void expandNode() {
        TreePath selectionPath = this.tree.getSelectionPath();
        ConceptTreeNode node = (ConceptTreeNode)selectionPath.getLastPathComponent();
        if (node == null || node.isLeaf()) {
            return;
        }
        this.expandMenuItem.setEnabled(false);
        this.expandMenuItem.setText("Expanding " + ((Concept)node.getUserObject()).getPrimaryConceptName().getName() + " ...");
        final ConceptTreeModel model = (ConceptTreeModel)this.tree.getModel();
        final Concept concept = (Concept)node.getUserObject();
        final TreePath fSelectionPath = selectionPath;
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                ConceptDAO dao = ConceptTreePopupMenu.this.knowledgebaseDAOFactory.newConceptDAO();
                Concept aConcept = (Concept)dao.find((Object)concept);
                Collection descendants = dao.findDescendents(aConcept);
                for (Concept c : descendants) {
                    model.loadNode(c.getPrimaryConceptName().getName());
                }
                dao.close();
                return null;
            }

            @Override
            protected void done() {
                ConceptTreePopupMenu.this.togglePath(fSelectionPath, true);
                ConceptTreePopupMenu.this.expandMenuItem.setText("Expand");
                ConceptTreePopupMenu.this.expandMenuItem.setEnabled(true);
            }
        };
        worker.execute();
    }

    private void showPrimaryImage() {
        TreePath selectionPath = this.tree.getSelectionPath();
        ConceptTreeNode node = (ConceptTreeNode)selectionPath.getLastPathComponent();
        Concept concept = (Concept)node.getUserObject();
        Media media = concept.getConceptMetadata().getPrimaryImage();
        try {
            URL url = new URL(media.getUrl());
            JImageUrlFrame imageFrame = new JImageUrlFrame(url);
            imageFrame.setTitle(concept.getPrimaryConceptName().getName());
            imageFrame.setDefaultCloseOperation(2);
            imageFrame.setLocationRelativeTo((Component)GlobalStateLookup.getSelectedFrame());
            imageFrame.setVisible(true);
        }
        catch (MalformedURLException ex) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("Unable to load " + media.getUrl()));
        }
    }

    private void togglePath(TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                ConceptTreeNode n = (ConceptTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.togglePath(path, expand);
            }
        }
        if (expand) {
            this.tree.expandPath(parent);
        } else {
            this.tree.collapsePath(parent);
        }
    }
}

