/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.tree;

import com.google.inject.Inject;
import foxtrot.Job;
import foxtrot.Worker;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.EventBus;
import org.mbari.swing.LabeledSpinningDialWaitIndicator;
import org.mbari.swing.SearchableTreePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameDAO;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.shared.ui.tree.ConceptTreeModel;
import vars.shared.ui.tree.ConceptTreeNode;

public class ConceptTreePanel
extends SearchableTreePanel {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MouseListener popupListener = new PopupListener();
    private final KeyListener enterListener = new EnterKeyListener();
    private final Collection<String> cachedGlobSearches;
    private final Collection<String> cachedWordSearches;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;
    private JPopupMenu popupMenu;

    @Inject
    public ConceptTreePanel(KnowledgebaseDAOFactory knowledgebaseDAOFactory) {
        this.knowledgebaseDAOFactory = knowledgebaseDAOFactory;
        this.cachedWordSearches = new HashSet<String>();
        this.cachedGlobSearches = new HashSet<String>();
    }

    public String getNodeTextToSearch(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        StringBuffer textToSearch = new StringBuffer();
        if (userObject instanceof Concept) {
            Concept concept = (Concept)node.getUserObject();
            ArrayList conceptNames = new ArrayList(concept.getConceptNames());
            for (ConceptName conceptName1 : conceptNames) {
                textToSearch.append(conceptName1.getName());
                textToSearch.append(" ");
            }
        }
        return textToSearch.toString();
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public boolean goToMatchingNode(String text, boolean useGlobSearch) {
        this.getSearchBtn().setEnabled(false);
        this.getSearchTextField().setEnabled(false);
        LabeledSpinningDialWaitIndicator waitIndicator = new LabeledSpinningDialWaitIndicator((JComponent)((Object)this), "Searching for '" + text + "'");
        this.loadNodes(text, useGlobSearch, waitIndicator);
        boolean ok = super.goToMatchingNode(text, useGlobSearch);
        waitIndicator.dispose();
        this.getSearchBtn().setEnabled(true);
        this.getSearchTextField().setEnabled(true);
        this.getSearchTextField().requestFocus();
        return ok;
    }

    private void loadNodes(final String text, final boolean useGlobSearch, final LabeledSpinningDialWaitIndicator waitIndicator) {
        Worker.post((Job)new Job(){

            public Object run() {
                Collection matches;
                block10: {
                    matches = null;
                    try {
                        ConceptNameDAO dao;
                        if (useGlobSearch) {
                            if (!ConceptTreePanel.this.cachedGlobSearches.contains(text)) {
                                dao = ConceptTreePanel.this.knowledgebaseDAOFactory.newConceptNameDAO();
                                dao.startTransaction();
                                matches = dao.findByNameContaining(text);
                                dao.endTransaction();
                                dao.close();
                                ConceptTreePanel.this.cachedGlobSearches.add(text);
                                ConceptTreePanel.this.cachedWordSearches.add(text);
                            }
                        } else if (!ConceptTreePanel.this.cachedWordSearches.contains(text)) {
                            dao = ConceptTreePanel.this.knowledgebaseDAOFactory.newConceptNameDAO();
                            dao.startTransaction();
                            matches = dao.findByNameStartingWith(text);
                            dao.endTransaction();
                            dao.close();
                            ConceptTreePanel.this.cachedWordSearches.add(text);
                        }
                    }
                    catch (Exception e) {
                        if (!ConceptTreePanel.this.log.isErrorEnabled()) break block10;
                        ConceptTreePanel.this.log.error("Database lookup of " + text + " failed", (Throwable)e);
                        EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                    }
                }
                try {
                    if (matches != null) {
                        for (final ConceptName conceptName : matches) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    waitIndicator.setLabel("Loading '" + conceptName.getName() + "'");
                                }
                            });
                            ConceptTreePanel.this.openNode(conceptName.getConcept());
                        }
                    }
                }
                catch (Exception e) {
                    ConceptTreePanel.this.log.error("A problem occurred with the database while loading concepts matching " + text, (Throwable)e);
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                }
                return matches;
            }
        });
    }

    public synchronized void openNode(Concept concept) {
        if (concept == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Opening node containing '" + concept.getPrimaryConceptName().getName() + "', " + concept);
        }
        final TreePath treePath = this.buildTreePathForNode(concept);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConceptTreePanel.this.getJTree().setSelectionPath(treePath);
                ConceptTreePanel.this.getJTree().scrollPathToVisible(treePath);
            }
        });
    }

    private TreePath buildTreePathForNode(Concept concept) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Opening node containing '" + concept.getPrimaryConceptName().getName() + "', " + concept);
        }
        if (concept == null) {
            return null;
        }
        final JTree tree = this.getJTree();
        final ConceptTreeModel model = (ConceptTreeModel)tree.getModel();
        final ConceptTreeNode node = model.loadNode(concept.getPrimaryConceptName().getName());
        final TreePath path = new TreePath(model.getPathToRoot(node));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                model.reload(node);
                tree.scrollPathToVisible(path);
            }
        });
        this.validate();
        return path;
    }

    public void refresh() {
        this.cachedGlobSearches.clear();
        this.cachedWordSearches.clear();
        ConceptTreeModel model = (ConceptTreeModel)this.getJTree().getModel();
        model.refresh();
    }

    public void refreshAndOpenNode(final Concept concept) {
        if (this.log.isDebugEnabled()) {
            String name = concept == null ? "the root node" : concept.getPrimaryConceptName().getName();
            this.log.debug("Refreshing ConceptTree and opening it to '" + name + "' -> " + concept);
        }
        this.refresh();
        Worker.post((Job)new Job(){

            public Object run() {
                ConceptTreePanel.this.openNode(concept);
                return null;
            }
        });
    }

    public void setJTree(JTree tree) {
        JTree oldTree = this.getJTree();
        if (oldTree != null) {
            oldTree.removeKeyListener(this.enterListener);
            oldTree.removeMouseListener(this.popupListener);
        }
        if (tree != null) {
            tree.addKeyListener(this.enterListener);
            tree.addMouseListener(this.popupListener);
        }
        super.setJTree(tree);
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        private void evalutePopup(MouseEvent e) {
            JPopupMenu p;
            if (e.isPopupTrigger() && ConceptTreePanel.this.getJTree().getSelectionCount() != 0 && (p = ConceptTreePanel.this.getPopupMenu()) != null) {
                ConceptTreePanel.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.evalutePopup(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.evalutePopup(event);
        }
    }

    private class EnterKeyListener
    extends KeyAdapter {
        private EnterKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            JTree tree;
            if (event.getKeyCode() == 10 && (tree = ConceptTreePanel.this.getJTree()) != null) {
                int row = tree.getSelectionRows()[0];
                if (tree.isCollapsed(row)) {
                    tree.expandRow(row);
                } else {
                    tree.collapseRow(row);
                }
            }
        }
    }
}

