/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.tree;

import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptPrimaryNameComparator;

public class ConceptTreeNode
extends DefaultMutableTreeNode {
    private boolean loaded;
    private static final Comparator<Concept> COMPARATOR = new ConceptPrimaryNameComparator();

    public ConceptTreeNode(Concept userObject) {
        super(userObject);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Override
    public void add(MutableTreeNode node) {
        if (node instanceof ConceptTreeNode) {
            ConceptTreeNode treeNode = (ConceptTreeNode)node;
            Concept thisObj = (Concept)treeNode.getUserObject();
            boolean added = false;
            for (int i = 0; i < this.getChildCount(); ++i) {
                ConceptTreeNode thatNode = (ConceptTreeNode)this.getChildAt(i);
                Concept thatObj = (Concept)thatNode.getUserObject();
                int c = COMPARATOR.compare(thisObj, thatObj);
                if (c == 0) {
                    super.add(node);
                    added = true;
                    break;
                }
                if (c >= 0) continue;
                super.insert(node, i);
                added = true;
                break;
            }
            if (!added) {
                super.add(node);
            }
        }
    }
}

