/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.tree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.shared.ui.tree.ConceptTreeConcept;
import vars.shared.ui.tree.ConceptTreeNode;

public class ConceptTreeModel
extends DefaultTreeModel {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;

    public ConceptTreeModel(KnowledgebaseDAOFactory knowledgebaseDAOFactory) {
        super(new ConceptTreeNode((Concept)new ConceptTreeConcept("Loading ...")));
        this.knowledgebaseDAOFactory = knowledgebaseDAOFactory;
        this.refresh();
    }

    private List<Concept> findFamilyTree(String name) {
        LinkedList<Concept> conceptList = new LinkedList<Concept>();
        ConceptDAO dao = this.knowledgebaseDAOFactory.newConceptDAO();
        dao.startTransaction();
        Concept concept = dao.findByName(name);
        conceptList.add(concept);
        while (concept.hasParent()) {
            concept = concept.getParentConcept();
            conceptList.addFirst(concept);
        }
        dao.endTransaction();
        dao.close();
        return conceptList;
    }

    @Override
    public int getChildCount(Object parent) {
        ConceptTreeNode parentNode = (ConceptTreeNode)parent;
        if (!parentNode.isLoaded()) {
            this.loadChildConcepts(parentNode);
        }
        return super.getChildCount(parent);
    }

    private void loadChildConcepts(final ConceptTreeNode node) {
        if (!node.isLoaded()) {
            node.removeAllChildren();
            ConceptDAO dao = this.knowledgebaseDAOFactory.newConceptDAO();
            dao.startTransaction();
            Concept concept = (Concept)node.getUserObject();
            concept = (Concept)dao.find((Object)concept);
            ArrayList childConcepts = new ArrayList(concept.getChildConcepts());
            for (Concept child : childConcepts) {
                ConceptTreeNode childNode = new ConceptTreeNode(child);
                childNode.setLoaded(false);
                if (child.hasChildConcepts()) {
                    ConceptTreeNode fakeNode = new ConceptTreeNode((Concept)new ConceptTreeConcept("Loading ..."));
                    fakeNode.setLoaded(true);
                    childNode.add(fakeNode);
                }
                node.add(childNode);
            }
            node.setLoaded(true);
            dao.endTransaction();
            dao.close();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConceptTreeModel.this.reload(node);
                }
            });
        }
    }

    ConceptTreeNode loadNode(String name) {
        List<Concept> list = this.findFamilyTree(name);
        Iterator<Concept> familyTree = list.iterator();
        familyTree.next();
        ConceptTreeNode treeNode = (ConceptTreeNode)this.getRoot();
        while (familyTree.hasNext()) {
            String nextConceptName = familyTree.next().getPrimaryConceptName().getName();
            this.loadChildConcepts(treeNode);
            boolean found = false;
            Enumeration<TreeNode> childrenNodes = treeNode.children();
            while (!found && childrenNodes.hasMoreElements()) {
                treeNode = (ConceptTreeNode)childrenNodes.nextElement();
                Concept concept = (Concept)treeNode.getUserObject();
                if (!nextConceptName.equals(concept.getPrimaryConceptName().getName())) continue;
                found = true;
            }
        }
        return treeNode;
    }

    public void refresh() {
        ConceptDAO conceptDAO = this.knowledgebaseDAOFactory.newConceptDAO();
        conceptDAO.startTransaction();
        Concept rootConcept = conceptDAO.findRoot();
        ArrayList childConcepts = new ArrayList(rootConcept.getChildConcepts());
        ConceptTreeNode rootNode = new ConceptTreeNode(rootConcept);
        for (Concept child : childConcepts) {
            ConceptTreeNode childNode = new ConceptTreeNode(child);
            childNode.setLoaded(false);
            if (child.hasChildConcepts()) {
                ConceptTreeNode fakeNode = new ConceptTreeNode((Concept)new ConceptTreeConcept("Loading ..."));
                fakeNode.setLoaded(true);
                childNode.add(fakeNode);
            }
            rootNode.add(childNode);
        }
        conceptDAO.endTransaction();
        conceptDAO.close();
        rootNode.setLoaded(true);
        super.setRoot(rootNode);
        super.reload();
    }

    @Override
    public void setRoot(TreeNode root) {
        if (!(root instanceof ConceptTreeNode)) {
            throw new IllegalArgumentException("The root must be an instance of ConceptTreeNode");
        }
        super.setRoot(root);
    }
}

