/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.tree;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.mbari.swing.SpinningDial;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptName;
import vars.shared.ui.tree.ConceptTreeConcept;
import vars.shared.ui.tree.ConceptTreeNode;

public class ConceptTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final String DEFAULT = "/vars/images/16/nav_plain_blue.png";
    private static final String DEFAULT_WITH_IMAGE = "/vars/images/16/nav_plain_blue_square_glass_grey.png";
    private static final String PENDING = "/vars/images/16/nav_plain_red.png";
    private static final String PENDING_WITH_IMAGE = "/vars/images/16/nav_plain_red_square_glass_grey.png";
    private static final long serialVersionUID = -7382528013502852004L;
    private static final Color pendingTextColor = Color.RED.brighter().brighter();
    private static final Color loadingTextColor = Color.GRAY;
    private final StringBuffer textBuf = new StringBuffer();
    private final Comparator<ConceptName> comparator = new Comparator<ConceptName>(){

        @Override
        public int compare(ConceptName o1, ConceptName o2) {
            String s1 = o1.getName();
            String s2 = o2.getName();
            return s1.compareToIgnoreCase(s2);
        }
    };
    private final ImageIcon defaultIcon = new ImageIcon(this.getClass().getResource("/vars/images/16/nav_plain_blue.png"));
    private final ImageIcon defaultWithImageIcon = new ImageIcon(this.getClass().getResource("/vars/images/16/nav_plain_blue_square_glass_grey.png"));
    private final Icon loadingIcon;
    private final ImageIcon pendingIcon = new ImageIcon(this.getClass().getResource("/vars/images/16/nav_plain_red.png"));
    private final ImageIcon pendingWithImageIcon = new ImageIcon(this.getClass().getResource("/vars/images/16/nav_plain_red_square_glass_grey.png"));

    public ConceptTreeCellRenderer() {
        this.loadingIcon = new SpinningDial(18, 18, 8);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
        ConceptTreeNode node = (ConceptTreeNode)value;
        Concept concept = (Concept)node.getUserObject();
        if (concept instanceof ConceptTreeConcept) {
            this.setText("Retrieving Concepts...");
            this.setIcon(this.loadingIcon);
            this.setForeground(loadingTextColor);
        } else {
            ImageIcon imageIcon = this.defaultIcon;
            if (concept.getConceptMetadata().isPendingApproval()) {
                imageIcon = concept.getConceptMetadata().getPrimaryImage() == null ? this.pendingIcon : this.pendingWithImageIcon;
                this.setForeground(pendingTextColor);
            } else {
                imageIcon = concept.getConceptMetadata().getPrimaryImage() == null ? this.defaultIcon : this.defaultWithImageIcon;
            }
            this.setIcon(imageIcon);
            this.textBuf.replace(0, this.textBuf.length(), concept.getPrimaryConceptName().getName());
            ArrayList secondaryNames = new ArrayList();
            secondaryNames.addAll(concept.getConceptNames());
            secondaryNames.remove(concept.getPrimaryConceptName());
            if (secondaryNames.size() > 0) {
                Collections.sort(secondaryNames, this.comparator);
                this.textBuf.append(" (");
                for (int i = 0; i < secondaryNames.size(); ++i) {
                    this.textBuf.append(((ConceptName)secondaryNames.get(i)).getName());
                    if (secondaryNames.size() - 1 == i) continue;
                    this.textBuf.append(", ");
                }
                this.textBuf.append(")");
            }
            this.setText(this.textBuf.toString());
        }
        return this;
    }
}

