/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.event;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.bushe.swing.event.EventTopicSubscriber;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorLevel;
import org.jdesktop.swingx.error.ErrorReporter;
import vars.shared.ui.event.EmailErrorReporter;

public class NonFatalErrorSubscriber
implements EventTopicSubscriber {
    private final Frame parentFrame;

    public NonFatalErrorSubscriber(Frame parent) {
        this.parentFrame = parent;
    }

    String formatStackTraceForDialogs(Throwable throwable, boolean isCause) {
        StringBuilder result = new StringBuilder();
        result.append("<h3>");
        if (isCause) {
            result.append("Caused by: ");
        }
        result.append(throwable.toString()).append("</h3>");
        String newLine = "<br/>";
        for (StackTraceElement element : throwable.getStackTrace()) {
            result.append(element);
            result.append("<br/>");
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            result.append(this.formatStackTraceForDialogs(cause, true));
        }
        return result.toString();
    }

    public void onEvent(String topic, Object error) {
        String msg = "An error occurred. Refer to the details for more information.";
        String details = null;
        Throwable data = null;
        if (error instanceof Throwable) {
            data = (Throwable)error;
            details = this.formatStackTraceForDialogs(data, true);
        } else {
            details = error.toString();
        }
        JXErrorPane errorPane = new JXErrorPane();
        ImageIcon errorIcon = this.randomImage();
        ErrorInfo errorInfo = new ErrorInfo("VARS - Something exceptional occurred (and we don't like that)", msg, details, null, data, ErrorLevel.WARNING, null);
        errorPane.setIcon((Icon)errorIcon);
        errorPane.setErrorInfo(errorInfo);
        errorPane.setErrorReporter((ErrorReporter)new EmailErrorReporter(errorPane));
        JXErrorPane.showDialog((Component)this.parentFrame, (JXErrorPane)errorPane);
    }

    ImageIcon randomImage() {
        ArrayList<String> images = new ArrayList<String>(){
            {
                this.add("/vars/images/warning/60_Whoops.jpg");
                this.add("/vars/images/warning/cartoonprogramming_thumb.jpg");
                this.add("/vars/images/warning/DragAndDrop.gif");
                this.add("/vars/images/warning/epic-fail1.jpg");
                this.add("/vars/images/warning/Frown.jpg");
                this.add("/vars/images/warning/funny-yoga-3.jpg");
                this.add("/vars/images/warning/Icon_download_bp_223x223.png");
                this.add("/vars/images/warning/jack-ziegler-computer-error-new-yorker-cartoon.jpg");
                this.add("/vars/images/warning/medium_whoops.jpg");
                this.add("/vars/images/warning/mistake-cartoon.gif");
                this.add("/vars/images/warning/tumblr_ls2kwbtKLS1r07233.jpg");
                this.add("/vars/images/warning/Whoops-Not-a-firefly.jpg");
                this.add("/vars/images/warning/whoops-too-many-cookies.jpg");
                this.add("/vars/images/warning/Whoops.jpg");
                this.add("/vars/images/warning/xkcd-free-will.png");
                this.add("/vars/images/warning/xkcd_mimic_octopus.png");
                this.add("/vars/images/warning/yell-back.jpg");
                this.add("/vars/images/yellow-smile.jpg");
            }
        };
        String image = (String)images.get((int)Math.floor(Math.random() * (double)images.size()));
        return new ImageIcon(this.getClass().getResource(image));
    }
}

