/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.event;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.bushe.swing.event.EventTopicSubscriber;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorLevel;
import org.jdesktop.swingx.error.ErrorReporter;
import vars.shared.ui.event.EmailErrorReporter;

public class FatalExceptionSubscriber
implements EventTopicSubscriber<Exception> {
    private final Frame parentFrame;

    public FatalExceptionSubscriber(Frame parent) {
        this.parentFrame = parent;
    }

    String formatStackTraceForDialogs(Throwable throwable, boolean isCause) {
        StringBuilder result = new StringBuilder();
        result.append("<h3>");
        if (isCause) {
            result.append("Caused by: ");
        }
        result.append(throwable.toString()).append("</h3>");
        String newLine = "<br/>";
        for (StackTraceElement element : throwable.getStackTrace()) {
            result.append(element);
            result.append("<br/>");
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            result.append(this.formatStackTraceForDialogs(cause, true));
        }
        return result.toString();
    }

    public void onEvent(String topic, Exception data) {
        String msg = this.randomHaiku();
        String details = this.formatStackTraceForDialogs(data, false);
        JXErrorPane errorPane = new JXErrorPane();
        ImageIcon errorIcon = this.randomImage();
        ErrorInfo errorInfo = new ErrorInfo("VARS - Fatal Error", msg, details, null, (Throwable)data, (Level)ErrorLevel.FATAL, null);
        errorPane.setIcon((Icon)errorIcon);
        errorPane.setErrorInfo(errorInfo);
        errorPane.setErrorReporter((ErrorReporter)new EmailErrorReporter(errorPane));
        JXErrorPane.showDialog(null, (JXErrorPane)errorPane);
    }

    String randomHaiku() {
        ArrayList<String> haikus = new ArrayList<String>(){
            {
                this.add("Chaos reigns within.\nReflect, repent, and restart.\nOrder shall return.");
                this.add("Errors have occurred.\nWe won't tell you where or why.\nLazy programmers.");
                this.add("A crash reduces\nyour expensive computer\nto a simple stone.");
                this.add("There is a chasm\nof carbon and silicon\nthe software can't bridge");
                this.add("Yesterday it worked\nToday it is not working\nSoftware is like that");
                this.add("To have no errors\nWould be life without meaning\nNo struggle, no joy");
                this.add("Error messages\ncannot completely convey.\nWe now know shared loss.");
                this.add("The code was willing,\nIt considered your request,\nBut the chips were weak.");
                this.add("Wind catches lily\nScatt'ring petals to the wind:\nApplication dies");
                this.add("Three things are certain:\nDeath, taxes and lost data.\nGuess which has occurred.");
                this.add("Rather than a beep\nOr a rude error message,\nThese words: \"Restart now.\"");
                this.add("ABORTED effort:\nClose all that you have.\nYou ask way too much.");
                this.add("The knowledgebase crashed.\nI am the Blue Screen of Death.\nNo one hears your screams.");
                this.add("No-one can tell\nwhat God or Heaven will do\nIf you divide by zero.");
                this.add("Some bugs have names\nOthers inscrutable numbers\nYours has not even that.");
                this.add("Riddle for student\nWhat error is so fatal\nIt has no message");
                this.add("Technical support\nWould be a flowing source of\nSweet commiseration.");
                this.add("Something you entered\ntranscended parameters\nSo much is unknown.");
                this.add("Your data was big\nIt might be very useful\nBut now it is gone.");
                this.add("In a wired world\n distractions consume ones thoughts\n... mindfulness returns");
            }
        };
        return (String)haikus.get((int)Math.floor(Math.random() * (double)haikus.size()));
    }

    ImageIcon randomImage() {
        ArrayList<String> images = new ArrayList<String>(){
            {
                this.add("/vars/images/red-frown_small.png");
                this.add("/vars/images/fatal/202.jpg");
                this.add("/vars/images/fatal/2010-01-04-null-pointer-exception.png");
                this.add("/vars/images/fatal/1204185247268.jpg");
                this.add("/vars/images/fatal/actualbug.jpg");
                this.add("/vars/images/fatal/bug.png");
                this.add("/vars/images/fatal/catchAllTheErrors-615x461.png");
                this.add("/vars/images/fatal/epic-fail4.jpg");
                this.add("/vars/images/fatal/error_cartoon.gif");
                this.add("/vars/images/fatal/fatal-error-cartoon.jpg");
                this.add("/vars/images/fatal/Flag_of_Edward_England.svg.png");
                this.add("/vars/images/fatal/Funny-Animals-EPIC-FAIL-Indeed.jpg");
                this.add("/vars/images/fatal/its_okay_i_wrote_an_exception.jpg");
                this.add("/vars/images/fatal/xkcd2.png");
            }
        };
        String image = (String)images.get((int)Math.floor(Math.random() * (double)images.size()));
        return new ImageIcon(this.getClass().getResource(image));
    }
}

