/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.event;

import java.awt.Component;
import java.awt.Frame;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.mail.HtmlEmail;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.mbari.awt.AwtUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.shared.ui.GlobalStateLookup;

public class EmailErrorReporter
implements ErrorReporter {
    private final JXErrorPane errorPane;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_EMAIL = "brian@mbari.org";
    private static final String DEFAULT_USER = "VARS Error Reporter";

    public EmailErrorReporter(JXErrorPane errorPane) {
        this.errorPane = errorPane;
    }

    public void reportError(ErrorInfo errorInfo) throws NullPointerException {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            UserAccount userAccount = GlobalStateLookup.getUserAccount();
            HtmlEmail email = new HtmlEmail();
            email.setHostName("mbarimail.mbari.org");
            email.setFrom(this.getEmail(userAccount), this.getName(userAccount));
            email.addTo(DEFAULT_EMAIL);
            email.setSubject("VARS Error Report: " + errorInfo.getTitle());
            email.setMsg("<html><body>" + df.format(new Date()) + "\n\n" + errorInfo.getDetailedErrorMessage() + "</body></html>");
            email.send();
        }
        catch (Exception e) {
            this.log.warn("Failed to send email error report", (Throwable)e);
        }
        Frame frame = AwtUtilities.getFrame((Component)this.errorPane);
        frame.dispose();
    }

    private String getName(UserAccount userAccount) {
        String name = null;
        if (userAccount == null) {
            name = DEFAULT_USER;
        } else {
            String firstName = userAccount.getFirstName() == null ? "" : userAccount.getFirstName();
            String lastName = userAccount.getLastName() == null ? "" : userAccount.getLastName();
            name = firstName.isEmpty() && lastName.isEmpty() ? DEFAULT_USER : firstName + " " + lastName;
        }
        return name;
    }

    private String getEmail(UserAccount userAccount) {
        String fromEmail;
        String string = fromEmail = userAccount == null ? DEFAULT_EMAIL : userAccount.getEmail();
        if (fromEmail == null) {
            fromEmail = DEFAULT_EMAIL;
        }
        return fromEmail;
    }
}

