/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.dialogs;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ToolBelt;
import vars.UserAccount;
import vars.jpa.VarsJpaModule;
import vars.shared.ui.UserAccountPreferencesPanel;
import vars.shared.ui.dialogs.CreateUserAccountDialog;
import vars.shared.ui.dialogs.DialogController;
import vars.shared.ui.dialogs.StandardDialog;

public class UserAccountDialog
extends StandardDialog {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private DialogController controller;
    private JTextField messageLabel;
    private UserAccountPreferencesPanel panel;
    private UserAccount userAccount;

    public UserAccountDialog() {
        this.initialize();
    }

    public UserAccountDialog(DialogController dialogController) {
        this.controller = dialogController;
        this.initialize();
    }

    public UserAccountDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initialize();
    }

    public UserAccountDialog(DialogController dialogController, Frame parent, boolean modal) {
        super(parent, modal);
        this.controller = dialogController;
        this.initialize();
    }

    public DialogController getDialogController() {
        return this.controller;
    }

    JTextField getMessageLabel() {
        if (this.messageLabel == null) {
            this.messageLabel = new JTextField("Create a new user. (* required field)");
            this.messageLabel.setEditable(false);
        }
        return this.messageLabel;
    }

    public UserAccountPreferencesPanel getPanel() {
        if (this.panel == null) {
            this.panel = new UserAccountPreferencesPanel();
        }
        return this.panel;
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    public void setUserAccount(UserAccount userAccount) {
        this.userAccount = userAccount;
    }

    private void initialize() {
        this.getContentPane().add((Component)this.getMessageLabel(), "North");
        this.getContentPane().add((Component)this.getPanel(), "Center");
        this.getOkayButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogController c = UserAccountDialog.this.getDialogController();
                if (c != null) {
                    c.doOkay();
                }
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogController c = UserAccountDialog.this.getDialogController();
                if (c != null) {
                    c.doCancel();
                }
            }
        });
        this.pack();
    }

    public static void main(String[] args) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new VarsJpaModule("vars-jpa-annotation", "vars-jpa-knowledgebase", "vars-jpa-misc")});
        ToolBelt toolBelt = (ToolBelt)injector.getInstance(ToolBelt.class);
        UserAccount admin = CreateUserAccountDialog.showDialog(null, true, "VARS - Create Administrator Account", toolBelt.getMiscDAOFactory(), toolBelt.getMiscFactory());
    }

    public void setDialogController(DialogController dialogController) {
        this.controller = dialogController;
    }

    public void setReturnValue(UserAccount userAccount) {
        this.userAccount = userAccount;
    }
}

