/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.dialogs;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.Frame;
import org.bushe.swing.event.EventBus;
import vars.MiscDAOFactory;
import vars.ToolBelt;
import vars.UserAccount;
import vars.UserAccountDAO;
import vars.jpa.VarsJpaModule;
import vars.shared.ui.dialogs.CreateUserAccountDialog;
import vars.shared.ui.dialogs.DialogController;
import vars.shared.ui.dialogs.UserAccountDialog;

public class ModifyUserAccountDialog
extends UserAccountDialog {
    private final MiscDAOFactory miscDAOFactory;

    public ModifyUserAccountDialog(MiscDAOFactory miscDAOFactory) {
        this.miscDAOFactory = miscDAOFactory;
        this.initialize();
        this.setDialogController(new Controller(this));
    }

    public ModifyUserAccountDialog(Frame parent, boolean modal, MiscDAOFactory miscDAOFactory) {
        super(parent, modal);
        this.miscDAOFactory = miscDAOFactory;
        this.initialize();
        this.setDialogController(new Controller(this));
    }

    private void initialize() {
        this.getPanel().getLoginTextField().setEditable(false);
        this.getPanel().getRoleComboBox().setEditable(false);
    }

    public static void main(String[] args) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new VarsJpaModule("vars-jpa-annotation", "vars-jpa-knowledgebase", "vars-jpa-misc")});
        ToolBelt toolBelt = (ToolBelt)injector.getInstance(ToolBelt.class);
        UserAccount admin = CreateUserAccountDialog.showDialog(null, true, "VARS - Create Administrator Account", toolBelt.getMiscDAOFactory(), toolBelt.getMiscFactory());
    }

    @Override
    public void setUserAccount(UserAccount userAccount) {
        super.setUserAccount(userAccount);
        this.getOkayButton().setEnabled(userAccount != null);
        this.getPanel().setUserAccount(userAccount);
    }

    public static UserAccount showDialog(Frame parent, boolean modal, String title, MiscDAOFactory miscDAOFactory) {
        ModifyUserAccountDialog dialog = new ModifyUserAccountDialog(parent, modal, miscDAOFactory);
        dialog.setTitle(title);
        dialog.setVisible(true);
        return dialog.getUserAccount();
    }

    private class Controller
    implements DialogController {
        private final UserAccountDialog dialog;

        public Controller(UserAccountDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void doCancel() {
            this.dialog.setReturnValue(null);
            this.dialog.dispose();
        }

        @Override
        public void doOkay() {
            boolean ok;
            String pwd1 = new String(this.dialog.getPanel().getPasswordField1().getPassword());
            String pwd2 = new String(this.dialog.getPanel().getPasswordField2().getPassword());
            pwd1 = pwd1.equals("") ? null : pwd1;
            pwd2 = pwd2.equals("") ? null : pwd2;
            boolean bl = ok = pwd1 == null && pwd2 == null || pwd1.equals(pwd2);
            if (!ok) {
                ModifyUserAccountDialog.this.getMessageLabel().setText("The passwords do not match");
                return;
            }
            try {
                UserAccountDAO dao = ModifyUserAccountDialog.this.miscDAOFactory.newUserAccountDAO();
                dao.startTransaction();
                UserAccount userAccount = dao.findByUserName(ModifyUserAccountDialog.this.getUserAccount().getUserName());
                if (userAccount == null) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("Unable to find a user with the name '" + ModifyUserAccountDialog.this.getUserAccount().getUserName()));
                    this.dialog.dispose();
                } else {
                    if (pwd1 != null) {
                        userAccount.setPassword(pwd1);
                    }
                    userAccount.setEmail(this.valueOf(ModifyUserAccountDialog.this.getPanel().getEmailTextField().getText()));
                    userAccount.setAffiliation(this.valueOf(ModifyUserAccountDialog.this.getPanel().getAffiliationTextField().getText()));
                    userAccount.setFirstName(this.valueOf(ModifyUserAccountDialog.this.getPanel().getFirstNameTextField().getText()));
                    userAccount.setLastName(this.valueOf(ModifyUserAccountDialog.this.getPanel().getLastNameTextField().getText()));
                }
                dao.endTransaction();
                ModifyUserAccountDialog.this.setReturnValue(userAccount);
            }
            catch (Exception e) {
                ModifyUserAccountDialog.this.setReturnValue(null);
                ModifyUserAccountDialog.this.log.error("Failed to update user in database", (Throwable)e);
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            }
            this.dialog.dispose();
        }

        private String valueOf(String v0) {
            String v1 = null;
            if (v0 != null && !v0.trim().isEmpty()) {
                v1 = v0;
            }
            return v1;
        }
    }
}

