/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.bushe.swing.event.EventBus;
import org.jdesktop.layout.GroupLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.MiscDAOFactory;
import vars.MiscFactory;
import vars.UserAccount;
import vars.UserAccountDAO;
import vars.shared.ui.FancyButton;
import vars.shared.ui.GlobalStateLookup;
import vars.shared.ui.UserAccountComboBox;
import vars.shared.ui.dialogs.CreateUserAccountDialog;

public class LoginDialog
extends JDialog {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JLabel msgLabel;
    private UserAccountComboBox nameComboBox;
    private JButton newUserButton;
    private final JDialog newUserDialog;
    private JButton okButton;
    private JPasswordField passwordField;
    private final MiscDAOFactory miscDAOFactory;
    private boolean passwordRequired = true;

    public LoginDialog(Frame parent, boolean modal, MiscDAOFactory miscDAOFactory, MiscFactory miscFactory) {
        super(parent, modal);
        this.miscDAOFactory = miscDAOFactory;
        this.newUserDialog = new CreateUserAccountDialog(parent, true, miscDAOFactory, miscFactory);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void cancelButtonKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.cancelButtonActionPerformed(null);
        }
    }

    private void close() {
        this.setVisible(false);
        this.msgLabel.setText(" ");
        this.passwordField.setText("");
        this.getNameComboBox().setRequestFocusEnabled(true);
    }

    UserAccountComboBox getNameComboBox() {
        if (this.nameComboBox == null) {
            this.nameComboBox = new UserAccountComboBox(this.miscDAOFactory);
        }
        return this.nameComboBox;
    }

    public boolean isPasswordRequired() {
        return this.passwordRequired;
    }

    public void setPasswordRequired(boolean passwordRequired) {
        this.passwordRequired = passwordRequired;
        this.passwordField.setEnabled(passwordRequired);
        this.jLabel3.setEnabled(passwordRequired);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.passwordField = new JPasswordField();
        this.cancelButton = new FancyButton();
        this.okButton = new FancyButton();
        this.newUserButton = new FancyButton();
        this.jLabel1 = new JLabel();
        this.msgLabel = new JLabel();
        this.setTitle("VARS - Login");
        this.setResizable(false);
        this.jLabel2.setText("Name:");
        this.jLabel3.setText("Password:");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("To log in, enter your name and password. If you can not\nremember your password, you can log in as a read-only\nuser by using the password 'guest'");
        this.jTextArea1.setFocusable(false);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/vars/images/24/delete2.png")));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.cancelButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LoginDialog.this.cancelButtonKeyReleased(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/vars/images/24/check2.png")));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.okButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LoginDialog.this.okButtonKeyReleased(evt);
            }
        });
        this.passwordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.okButtonActionPerformed(e);
            }
        });
        this.newUserButton.setIcon(new ImageIcon(this.getClass().getResource("/vars/images/24/user1_add.png")));
        this.newUserButton.setFocusable(false);
        this.newUserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.newUserButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Create a new user account");
        this.msgLabel.setForeground(new Color(153, 0, 0));
        this.msgLabel.setText(" ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.msgLabel, -1, 360, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 360, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)((Object)this.getNameComboBox()), -1, 287, Short.MAX_VALUE).add((Component)this.passwordField, -1, 287, Short.MAX_VALUE))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.okButton).addPreferredGap(0).add((Component)this.cancelButton)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.newUserButton).addPreferredGap(0).add((Component)this.jLabel1))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)((Object)this.getNameComboBox()), -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.passwordField, -2, -1, -2)).add(15, 15, 15).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.newUserButton).add((Component)this.jLabel1)).addPreferredGap(0).add((Component)this.msgLabel).addPreferredGap(0, 22, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.okButton)).addContainerGap()));
        this.pack();
    }

    private void newUserButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.newUserDialog.setVisible(true);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        UserAccount userAccount = null;
        String userName = (String)this.getNameComboBox().getSelectedItem();
        String password = new String(this.passwordField.getPassword());
        boolean success = false;
        try {
            UserAccountDAO userAccountDAO = this.miscDAOFactory.newUserAccountDAO();
            userAccountDAO.startTransaction();
            userAccount = userAccountDAO.findByUserName(userName.trim());
            userAccountDAO.endTransaction();
            userAccountDAO.close();
        }
        catch (Exception e) {
            this.msgLabel.setText("Database connection failed");
            this.log.error("Failed to look up '" + userName + "'", (Throwable)e);
        }
        if (userAccount == null) {
            this.msgLabel.setText("Unable to find '" + userName + "' in the database");
        } else {
            success = this.passwordRequired ? userAccount.authenticate(password) : true;
            if (!success) {
                this.msgLabel.setText("Invalid password");
            }
        }
        if (success) {
            GlobalStateLookup.setUserAccount(userAccount);
            this.close();
        }
    }

    private void okButtonKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.okButtonActionPerformed(null);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.updateNameComboBox();
            this.nameComboBox.requestFocus();
            this.nameComboBox.getEditor().selectAll();
        }
        super.setVisible(b);
    }

    private void updateNameComboBox() {
        try {
            this.getNameComboBox().update();
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
        }
    }
}

