/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.dialogs;

import java.awt.Frame;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.MiscDAOFactory;
import vars.MiscFactory;
import vars.UserAccount;
import vars.UserAccountDAO;
import vars.shared.ui.GlobalStateLookup;
import vars.shared.ui.dialogs.LoginDialog;

public class LoginAction
extends ActionAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final LoginDialog loginDialog;

    public LoginAction(MiscDAOFactory miscDAOFactory, MiscFactory miscFactory) {
        this(miscDAOFactory, miscFactory, true);
    }

    public LoginAction(MiscDAOFactory miscDAOFactory, MiscFactory miscFactory, boolean passwordRequired) {
        Frame frame = GlobalStateLookup.getSelectedFrame();
        this.loginDialog = new LoginDialog(frame, true, miscDAOFactory, miscFactory);
        this.loginDialog.setPasswordRequired(passwordRequired);
    }

    public void doAction() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Attempting to log in");
        }
        this.loginDialog.setVisible(true);
    }

    public LoginDialog getDialog() {
        return this.loginDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String userName, String password, UserAccountDAO userAccountDAO) {
        boolean ok;
        UserAccount userAccount;
        block6: {
            userAccount = null;
            ok = false;
            try {
                userAccount = userAccountDAO.findByUserName(userName.trim());
                if (userAccount != null && userAccount.authenticate(password)) {
                    ok = true;
                    break block6;
                }
                userAccount = null;
            }
            catch (Exception daoe) {
                try {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("Unable to login ", (Throwable)daoe);
                    }
                    userAccount = null;
                }
                catch (Throwable throwable) {
                    GlobalStateLookup.setUserAccount(userAccount);
                    throw throwable;
                }
                GlobalStateLookup.setUserAccount(userAccount);
            }
        }
        GlobalStateLookup.setUserAccount(userAccount);
        return ok;
    }
}

