/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.dialogs;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.Frame;
import vars.MiscDAOFactory;
import vars.MiscFactory;
import vars.ToolBelt;
import vars.UserAccount;
import vars.UserAccountDAO;
import vars.UserAccountRoles;
import vars.jpa.VarsJpaModule;
import vars.shared.ui.UserAccountPreferencesPanel;
import vars.shared.ui.dialogs.DialogController;
import vars.shared.ui.dialogs.UserAccountDialog;

public class CreateUserAccountDialog
extends UserAccountDialog {
    private final MiscDAOFactory miscDAOFactory;
    private final MiscFactory miscFactory;

    public CreateUserAccountDialog(MiscDAOFactory miscDAOFactory, MiscFactory miscFactory) {
        this.miscDAOFactory = miscDAOFactory;
        this.miscFactory = miscFactory;
        this.setDialogController(new Controller(this));
        this.getPanel().getRoleComboBox().setSelectedItem(UserAccountRoles.READONLY.toString());
        this.getPanel().getRoleComboBox().setEnabled(false);
    }

    public CreateUserAccountDialog(Frame parent, boolean modal, MiscDAOFactory miscDAOFactory, MiscFactory miscFactory) {
        super(parent, modal);
        this.miscDAOFactory = miscDAOFactory;
        this.miscFactory = miscFactory;
        this.setDialogController(new Controller(this));
    }

    public static void main(String[] args) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new VarsJpaModule("vars-jpa-annotation", "vars-jpa-knowledgebase", "vars-jpa-misc")});
        ToolBelt toolBelt = (ToolBelt)injector.getInstance(ToolBelt.class);
        UserAccount admin = CreateUserAccountDialog.showDialog(null, true, "VARS - Create Administrator Account", toolBelt.getMiscDAOFactory(), toolBelt.getMiscFactory());
    }

    public static UserAccount showDialog(Frame parent, boolean modal, String title, MiscDAOFactory miscDAOFactory, MiscFactory miscFactory) {
        CreateUserAccountDialog dialog = new CreateUserAccountDialog(parent, modal, miscDAOFactory, miscFactory);
        dialog.setTitle(title);
        dialog.setVisible(true);
        return dialog.getUserAccount();
    }

    @Override
    public void setUserAccount(UserAccount userAccount) {
        throw new UnsupportedOperationException("You can't call this method on the 'CreateUserAccountDialog'!");
    }

    private class Controller
    implements DialogController {
        private final UserAccountDialog dialog;

        public Controller(UserAccountDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void doCancel() {
            this.dialog.setReturnValue(null);
            this.dialog.setVisible(false);
            this.dialog.getPanel().reset();
            this.dialog.dispose();
        }

        @Override
        public void doOkay() {
            block8: {
                String pwd2;
                UserAccount userAccount = null;
                UserAccountPreferencesPanel panel = this.dialog.getPanel();
                String userName = panel.getLoginTextField().getText();
                String pwd1 = new String(panel.getPasswordField1().getPassword());
                if (pwd1.equals(pwd2 = new String(panel.getPasswordField2().getPassword()))) {
                    UserAccountDAO userAccountDAO = CreateUserAccountDialog.this.miscDAOFactory.newUserAccountDAO();
                    userAccountDAO.startTransaction();
                    try {
                        userAccount = userAccountDAO.findByUserName(userName);
                    }
                    catch (Exception ex) {
                        CreateUserAccountDialog.this.getMessageLabel().setText("An error occured while connecting to the database");
                        CreateUserAccountDialog.this.log.warn("An error occured while looking up " + userName, (Throwable)ex);
                        return;
                    }
                    if (userAccount != null) {
                        CreateUserAccountDialog.this.getMessageLabel().setText("The login, ' " + userName + "', already exists in the database");
                    } else {
                        userAccount = CreateUserAccountDialog.this.miscFactory.newUserAccount();
                        userAccount.setUserName(userName);
                        userAccount.setPassword(pwd1);
                        userAccount.setRole(UserAccountRoles.READONLY.toString());
                        userAccount.setEmail(panel.getEmailTextField().getText());
                        userAccount.setAffiliation(panel.getAffiliationTextField().getText());
                        userAccount.setFirstName(panel.getFirstNameTextField().getText());
                        userAccount.setLastName(panel.getLastNameTextField().getText());
                        try {
                            userAccountDAO.persist((Object)userAccount);
                            CreateUserAccountDialog.this.setVisible(false);
                            this.dialog.getPanel().reset();
                        }
                        catch (Exception ex) {
                            CreateUserAccountDialog.this.getMessageLabel().setText("A database error occurred. Unable to insert a new user into the database");
                            CreateUserAccountDialog.this.log.warn("An error occured while inserting " + userName + " into the database", (Throwable)ex);
                            break block8;
                        }
                        userAccountDAO.endTransaction();
                        userAccountDAO.close();
                        CreateUserAccountDialog.this.setReturnValue(userAccount);
                    }
                } else {
                    CreateUserAccountDialog.this.getMessageLabel().setText("The passwords do not match");
                }
            }
        }
    }
}

