/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.bushe.swing.event.EventBus;
import vars.MiscDAOFactory;
import vars.UserAccount;
import vars.UserAccountDAO;
import vars.shared.ui.UserAccountComboBox;
import vars.shared.ui.UserAccountPreferencesPanel;
import vars.shared.ui.dialogs.StandardDialog;

public class AdministorUserAccountDialog
extends StandardDialog {
    private UserAccountComboBox comboBox;
    private final MiscDAOFactory miscDAOFactory;
    private UserAccountPreferencesPanel panel;

    public AdministorUserAccountDialog(Frame owner, String title, boolean modal, MiscDAOFactory miscDAOFactory) {
        super(owner, title, modal);
        this.miscDAOFactory = miscDAOFactory;
        this.initialize();
        this.pack();
    }

    public void doOkay() {
        boolean ok;
        String pwd1 = new String(this.getPanel().getPasswordField1().getPassword());
        String pwd2 = new String(this.getPanel().getPasswordField2().getPassword());
        pwd1 = pwd1.equals("") ? null : pwd1;
        pwd2 = pwd2.equals("") ? null : pwd2;
        boolean bl = ok = pwd1 == null && pwd2 == null || pwd1.equals(pwd2);
        if (!ok) {
            return;
        }
        try {
            UserAccount userAccount = this.getComboBox().getSelectedUserAccount();
            if (userAccount != null) {
                UserAccountDAO dao = this.miscDAOFactory.newUserAccountDAO();
                dao.startTransaction();
                userAccount = (UserAccount)dao.find((Object)userAccount);
                if (userAccount == null) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"Unable to find a the selected user");
                    this.dispose();
                } else {
                    if (pwd1 != null) {
                        userAccount.setPassword(pwd1);
                    }
                    userAccount.setEmail(this.valueOf(this.getPanel().getEmailTextField().getText()));
                    userAccount.setAffiliation(this.valueOf(this.getPanel().getAffiliationTextField().getText()));
                    userAccount.setFirstName(this.valueOf(this.getPanel().getFirstNameTextField().getText()));
                    userAccount.setLastName(this.valueOf(this.getPanel().getLastNameTextField().getText()));
                }
                dao.endTransaction();
            }
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
        }
        this.dispose();
        this.getComboBox().update();
    }

    public void setUserAccount(UserAccount userAccount) {
        if (userAccount != null) {
            this.getComboBox().setSelectedUserName(userAccount.getUserName());
        }
    }

    private UserAccountComboBox getComboBox() {
        if (this.comboBox == null) {
            this.comboBox = new UserAccountComboBox(this.miscDAOFactory);
            this.comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    UserAccount userAccount = AdministorUserAccountDialog.this.comboBox.getSelectedUserAccount();
                    AdministorUserAccountDialog.this.getPanel().setUserAccount(userAccount);
                }
            });
            this.comboBox.update();
        }
        return this.comboBox;
    }

    private UserAccountPreferencesPanel getPanel() {
        if (this.panel == null) {
            this.panel = new UserAccountPreferencesPanel();
        }
        return this.panel;
    }

    public UserAccount getSelectedUser() {
        return this.comboBox.getSelectedUserAccount();
    }

    private void initialize() {
        this.getContentPane().add((Component)((Object)this.getComboBox()), "North");
        this.getContentPane().add((Component)this.getPanel(), "Center");
        this.getOkayButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdministorUserAccountDialog.this.doOkay();
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdministorUserAccountDialog.this.dispose();
            }
        });
    }

    private String valueOf(String v0) {
        String v1 = null;
        if (v0 != null && !v0.trim().isEmpty()) {
            v1 = v0;
        }
        return v1;
    }
}

