/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui;

import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.UserAccountRoles;

public class UserAccountPreferencesPanel
extends JPanel {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private JTextField affiliationTextField;
    private JTextField emailTextField;
    private JTextField firstNameTextField;
    private JTextField lastNameTextField;
    private JLabel lblAffiliationorganization;
    private JLabel lblEmail;
    private JLabel lblFirstName;
    private JLabel lblLastName;
    private JLabel lblLogin;
    private JLabel lblPassword;
    private JLabel lblPasswordagain;
    private JTextField loginTextField;
    private JPasswordField passwordField1;
    private JPasswordField passwordField2;
    private UserAccount userAccount;
    private JLabel lblPermissions;
    private JComboBox roleComboBox;

    public UserAccountPreferencesPanel() {
        this.initialize();
    }

    public JTextField getAffiliationTextField() {
        if (this.affiliationTextField == null) {
            this.affiliationTextField = new JTextField();
            this.affiliationTextField.setColumns(10);
        }
        return this.affiliationTextField;
    }

    public JTextField getEmailTextField() {
        if (this.emailTextField == null) {
            this.emailTextField = new JTextField();
            this.emailTextField.setColumns(10);
        }
        return this.emailTextField;
    }

    public JTextField getFirstNameTextField() {
        if (this.firstNameTextField == null) {
            this.firstNameTextField = new JTextField();
            this.firstNameTextField.setColumns(10);
        }
        return this.firstNameTextField;
    }

    public JTextField getLastNameTextField() {
        if (this.lastNameTextField == null) {
            this.lastNameTextField = new JTextField();
            this.lastNameTextField.setColumns(10);
        }
        return this.lastNameTextField;
    }

    private JLabel getLblAffiliationorganization() {
        if (this.lblAffiliationorganization == null) {
            this.lblAffiliationorganization = new JLabel("Affiliation/Organization:");
        }
        return this.lblAffiliationorganization;
    }

    private JLabel getLblEmail() {
        if (this.lblEmail == null) {
            this.lblEmail = new JLabel("Email:");
        }
        return this.lblEmail;
    }

    private JLabel getLblFirstName() {
        if (this.lblFirstName == null) {
            this.lblFirstName = new JLabel("First Name:");
        }
        return this.lblFirstName;
    }

    private JLabel getLblLastName() {
        if (this.lblLastName == null) {
            this.lblLastName = new JLabel("Last Name:");
        }
        return this.lblLastName;
    }

    private JLabel getLblLogin() {
        if (this.lblLogin == null) {
            this.lblLogin = new JLabel("* Login:");
        }
        return this.lblLogin;
    }

    private JLabel getLblPassword() {
        if (this.lblPassword == null) {
            this.lblPassword = new JLabel("* Password:");
        }
        return this.lblPassword;
    }

    private JLabel getLblPasswordagain() {
        if (this.lblPasswordagain == null) {
            this.lblPasswordagain = new JLabel("* Password (again):");
        }
        return this.lblPasswordagain;
    }

    public JTextField getLoginTextField() {
        if (this.loginTextField == null) {
            this.loginTextField = new JTextField();
            this.loginTextField.setColumns(10);
        }
        return this.loginTextField;
    }

    public void reset() {
        this.getFirstNameTextField().setText("");
        this.getLoginTextField().setText("");
        this.getLastNameTextField().setText("");
        this.getPasswordField1().setText("");
        this.getPasswordField2().setText("");
        this.getEmailTextField().setText("");
        this.getAffiliationTextField().setText("");
    }

    private void initialize() {
        GroupLayout gl_panel = new GroupLayout(this);
        gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addContainerGap().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLblAffiliationorganization()).addComponent(this.getLblLastName()).addComponent(this.getLblEmail()).addComponent(this.getLblFirstName()).addComponent(this.getLblPasswordagain()).addComponent(this.getLblPassword()).addComponent(this.getLblLogin()).addComponent(this.getLblPermissions())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLoginTextField(), -1, 277, Short.MAX_VALUE).addComponent(this.getPasswordField1(), -1, 277, Short.MAX_VALUE).addComponent(this.getPasswordField2(), -1, 277, Short.MAX_VALUE).addComponent(this.getFirstNameTextField(), -1, 277, Short.MAX_VALUE).addComponent(this.getLastNameTextField(), GroupLayout.Alignment.TRAILING, -1, 277, Short.MAX_VALUE).addComponent(this.getEmailTextField(), GroupLayout.Alignment.TRAILING, -1, 277, Short.MAX_VALUE).addComponent(this.getAffiliationTextField(), -1, 277, Short.MAX_VALUE).addComponent(this.getRoleComboBox(), 0, 277, Short.MAX_VALUE)).addContainerGap()));
        gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addContainerGap().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblLogin()).addComponent(this.getLoginTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblPassword()).addComponent(this.getPasswordField1(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblPasswordagain()).addComponent(this.getPasswordField2(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblFirstName()).addComponent(this.getFirstNameTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblLastName()).addComponent(this.getLastNameTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblEmail()).addComponent(this.getEmailTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblAffiliationorganization()).addComponent(this.getAffiliationTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblPermissions()).addComponent(this.getRoleComboBox(), -2, -1, -2))));
        this.setLayout(gl_panel);
    }

    public JPasswordField getPasswordField1() {
        if (this.passwordField1 == null) {
            this.passwordField1 = new JPasswordField();
        }
        return this.passwordField1;
    }

    public JPasswordField getPasswordField2() {
        if (this.passwordField2 == null) {
            this.passwordField2 = new JPasswordField();
        }
        return this.passwordField2;
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    public void setUserAccount(UserAccount userAccount) {
        this.userAccount = userAccount;
        if (userAccount == null) {
            this.reset();
        } else {
            this.getLoginTextField().setText(userAccount.getUserName());
            this.getEmailTextField().setText(userAccount.getEmail());
            this.getAffiliationTextField().setText(userAccount.getAffiliation());
            this.getFirstNameTextField().setText(userAccount.getFirstName());
            this.getLastNameTextField().setText(userAccount.getLastName());
            this.getRoleComboBox().setSelectedItem(userAccount.getRole());
            this.getPasswordField1().setText("");
            this.getPasswordField2().setText("");
        }
    }

    private JLabel getLblPermissions() {
        if (this.lblPermissions == null) {
            this.lblPermissions = new JLabel("Permissions:");
        }
        return this.lblPermissions;
    }

    public JComboBox getRoleComboBox() {
        if (this.roleComboBox == null) {
            this.roleComboBox = new JComboBox();
            UserAccountRoles[] roles = UserAccountRoles.values();
            for (int i = 0; i < roles.length; ++i) {
                this.roleComboBox.addItem(roles[i].toString());
            }
            this.roleComboBox.setSelectedItem(UserAccountRoles.READONLY.toString());
        }
        return this.roleComboBox;
    }
}

