/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.mbari.swing.FancyComboBox;
import org.mbari.swing.SortedComboBoxModel;
import org.mbari.text.IgnoreCaseToStringComparator;
import vars.MiscDAOFactory;
import vars.UserAccount;
import vars.UserAccountDAO;

public class UserAccountComboBox
extends FancyComboBox {
    private static final Comparator comparator = new IgnoreCaseToStringComparator();
    private static final Comparator<UserAccount> userAccountComparator = new Comparator<UserAccount>(){

        @Override
        public int compare(UserAccount user1, UserAccount user2) {
            return comparator.compare(user1.getUserName(), user2.getUserName());
        }
    };
    private final List<UserAccount> userAccounts = Collections.synchronizedList(new ArrayList());
    private final MiscDAOFactory miscDAOFactory;

    public UserAccountComboBox(MiscDAOFactory miscDAOFactory) {
        this.miscDAOFactory = miscDAOFactory;
        this.setComparator(comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAccount getSelectedUserAccount() {
        UserAccount userAccount = null;
        String userName = (String)this.getSelectedItem();
        List<UserAccount> list = this.userAccounts;
        synchronized (list) {
            int index = Collections.binarySearch(this.userAccounts, userName, comparator);
            if (index > -1) {
                userAccount = this.userAccounts.get(index);
            }
        }
        return userAccount;
    }

    public void setSelectedUserName(String userName) {
        SortedComboBoxModel model = (SortedComboBoxModel)this.getModel();
        if (model.contains((Object)userName)) {
            model.setSelectedItem((Object)userName);
        } else {
            model.setSelectedItem(model.getElementAt(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        SortedComboBoxModel model = (SortedComboBoxModel)this.getModel();
        List<UserAccount> list = this.userAccounts;
        synchronized (list) {
            this.userAccounts.clear();
            UserAccountDAO userAccountDAO = this.miscDAOFactory.newUserAccountDAO();
            userAccountDAO.startTransaction();
            Collection accounts = userAccountDAO.findAll();
            userAccountDAO.endTransaction();
            userAccountDAO.close();
            this.userAccounts.addAll(accounts);
            Collections.sort(this.userAccounts, userAccountComparator);
            ArrayList<String> names = new ArrayList<String>();
            for (UserAccount userAccount : this.userAccounts) {
                names.add(userAccount.getUserName());
            }
            model.setItems(names);
        }
        this.setSelectedUserName(System.getProperty("user.name"));
    }
}

