/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui;

import com.google.common.collect.ImmutableList;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.List;

public class StringTransferable
implements Transferable {
    public static final DataFlavor LOCAL_STRING_FLAVOR = DataFlavor.stringFlavor;
    private static final List<DataFlavor> flavorList = ImmutableList.of((Object)LOCAL_STRING_FLAVOR);
    public static final DataFlavor[] flavors = flavorList.toArray(new DataFlavor[0]);
    private String string;

    public StringTransferable(String string) {
        this.string = string;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (LOCAL_STRING_FLAVOR.equals(flavor)) {
            return this.string;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavorList.contains(flavor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.string + ")";
    }
}

