/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import vars.ILink;
import vars.annotation.AnnotationPersistenceService;
import vars.jpa.VarsJpaModule;
import vars.knowledgebase.LinkTemplate;
import vars.shared.ui.LinkSelectionPanel;
import vars.shared.ui.dialogs.StandardDialog;

public class LinkSelectionPanelDemo {
    public static void main(String[] args) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new VarsJpaModule("vars-jpa-annotation", "vars-jpa-knowledgebase", "vars-jpa-misc")});
        AnnotationPersistenceService annotationPersistenceService = (AnnotationPersistenceService)injector.getInstance(AnnotationPersistenceService.class);
        Collection linkTemplates = annotationPersistenceService.findLinkTemplatesFor(annotationPersistenceService.findRootConcept());
        Collection links = Collections2.transform((Collection)linkTemplates, (Function)new Function<LinkTemplate, ILink>(){

            public ILink apply(LinkTemplate from) {
                return from;
            }
        });
        LinkSelectionPanel panel = new LinkSelectionPanel(annotationPersistenceService);
        panel.setLinks(links);
        StandardDialog dialog = new StandardDialog();
        dialog.add((Component)panel, "Center");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
        dialog.getOkayButton().addActionListener(actionListener);
        dialog.getCancelButton().addActionListener(actionListener);
        dialog.pack();
        dialog.setVisible(true);
    }
}

