/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui;

import com.google.inject.Inject;
import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.bushe.swing.event.EventBus;
import org.mbari.swing.LabeledSpinningDialWaitIndicator;
import org.mbari.swing.SearchableComboBoxModel;
import org.mbari.swing.SortedComboBoxModel;
import org.mbari.text.ObjectToStringConverter;
import vars.ILink;
import vars.LinkBean;
import vars.LinkComparator;
import vars.LinkUtilities;
import vars.annotation.AnnotationPersistenceService;
import vars.knowledgebase.Concept;
import vars.shared.ui.HierachicalConceptNameComboBox;
import vars.shared.ui.LinkListCellRenderer;

public class LinkSelectionPanel
extends JPanel {
    private final ILink DEFAULT_LINK = new LinkBean("nil", "nil", "nil");
    private final AnnotationPersistenceService annotationPersistenceService;
    private JLabel lblLinkName;
    private JLabel lblLinkValue;
    private JLabel lblSearchFor;
    private JLabel lblToConcept;
    private JTextField linkNameTextField;
    private JTextField linkValueTextField;
    private JComboBox linksComboBox;
    private JTextField searchTextField;
    private HierachicalConceptNameComboBox toConceptComboBox;

    @Inject
    public LinkSelectionPanel(AnnotationPersistenceService annotationPersistenceService) {
        this.annotationPersistenceService = annotationPersistenceService;
        this.initialize();
    }

    private JLabel getLblLinkName() {
        if (this.lblLinkName == null) {
            this.lblLinkName = new JLabel("Link Name");
        }
        return this.lblLinkName;
    }

    private JLabel getLblLinkValue() {
        if (this.lblLinkValue == null) {
            this.lblLinkValue = new JLabel("Link Value");
        }
        return this.lblLinkValue;
    }

    private JLabel getLblSearchFor() {
        if (this.lblSearchFor == null) {
            this.lblSearchFor = new JLabel("Search For");
        }
        return this.lblSearchFor;
    }

    private JLabel getLblToConcept() {
        if (this.lblToConcept == null) {
            this.lblToConcept = new JLabel("To Concept");
        }
        return this.lblToConcept;
    }

    public JTextField getLinkNameTextField() {
        if (this.linkNameTextField == null) {
            this.linkNameTextField = new JTextField();
            this.linkNameTextField.setEditable(false);
            this.linkNameTextField.setColumns(10);
        }
        return this.linkNameTextField;
    }

    public JTextField getLinkValueTextField() {
        if (this.linkValueTextField == null) {
            this.linkValueTextField = new JTextField();
            this.linkValueTextField.setColumns(10);
        }
        return this.linkValueTextField;
    }

    private JComboBox getLinksComboBox() {
        if (this.linksComboBox == null) {
            this.linksComboBox = new JComboBox();
            this.linksComboBox.setRenderer(new LinkListCellRenderer());
            this.linksComboBox.setModel(new SearchableComboBoxModel((Comparator)new LinkComparator(), (ObjectToStringConverter)new ObjectToStringConverter<ILink>(){

                public String convert(ILink object) {
                    return LinkUtilities.formatAsString((ILink)object);
                }
            }));
            this.linksComboBox.setToolTipText("Links in Knowledgebase");
            this.linksComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LinkSelectionPanel.this.setLink((ILink)e.getItem());
                    }
                }
            });
        }
        return this.linksComboBox;
    }

    private JTextField getSearchTextField() {
        if (this.searchTextField == null) {
            this.searchTextField = new JTextField();
            this.searchTextField.setColumns(10);
            this.searchTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    LinkSelectionPanel.this.searchTextField.setSelectionStart(0);
                    LinkSelectionPanel.this.searchTextField.setSelectionEnd(LinkSelectionPanel.this.searchTextField.getText().length());
                }
            });
            this.searchTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index;
                    JComboBox comboBox = LinkSelectionPanel.this.getLinksComboBox();
                    SearchableComboBoxModel model = (SearchableComboBoxModel)comboBox.getModel();
                    int startIndex = comboBox.getSelectedIndex() + 1;
                    if (startIndex >= model.getSize()) {
                        startIndex = 0;
                    }
                    if ((index = model.searchForItemContaining(LinkSelectionPanel.this.searchTextField.getText(), startIndex)) > -1) {
                        comboBox.setSelectedIndex(index);
                        comboBox.hidePopup();
                    } else if (startIndex > 0 && (index = model.searchForItemContaining(LinkSelectionPanel.this.searchTextField.getText())) > -1) {
                        comboBox.setSelectedIndex(index);
                        comboBox.hidePopup();
                    }
                }
            });
        }
        return this.searchTextField;
    }

    public HierachicalConceptNameComboBox getToConceptComboBox() {
        if (this.toConceptComboBox == null) {
            this.toConceptComboBox = new HierachicalConceptNameComboBox(this.annotationPersistenceService);
            this.toConceptComboBox.setToolTipText("To Concept");
            this.toConceptComboBox.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    LinkSelectionPanel.this.toConceptComboBox.getEditor().selectAll();
                }
            });
        }
        return this.toConceptComboBox;
    }

    protected void initialize() {
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLinksComboBox(), 0, 438, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.getLblSearchFor()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getSearchTextField(), -1, 363, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLblLinkName()).addComponent(this.getLblToConcept()).addComponent(this.getLblLinkValue())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)((Object)this.getToConceptComboBox()), 0, 360, Short.MAX_VALUE).addComponent(this.getLinkNameTextField(), -1, 365, Short.MAX_VALUE).addComponent(this.getLinkValueTextField(), GroupLayout.Alignment.TRAILING, -1, 360, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSearchFor()).addComponent(this.getSearchTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getLinksComboBox(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblLinkName()).addComponent(this.getLinkNameTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblToConcept()).addComponent((Component)((Object)this.getToConceptComboBox()), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblLinkValue()).addComponent(this.getLinkValueTextField(), -2, -1, -2)).addContainerGap(70, Short.MAX_VALUE)));
        this.setLayout(groupLayout);
        this.setLinks(new ArrayList<ILink>());
        this.resetDisplay();
    }

    public void resetDisplay() {
        this.getSearchTextField().setText("");
        this.setLink(this.DEFAULT_LINK);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getToConceptComboBox().setEnabled(enabled);
        this.getLinkNameTextField().setEnabled(enabled);
        this.getLinkValueTextField().setEnabled(enabled);
        this.getLinksComboBox().setEnabled(enabled);
    }

    public void setLink(final ILink link) {
        LabeledSpinningDialWaitIndicator waitIndicator = new LabeledSpinningDialWaitIndicator((JComponent)this, "Loading " + link.getToConcept() + " ...");
        this.getLinkNameTextField().setText(link.getLinkName());
        this.getLinkValueTextField().setText(link.getLinkValue());
        HierachicalConceptNameComboBox comboBox = this.getToConceptComboBox();
        comboBox.hidePopup();
        this.getLinksComboBox().hidePopup();
        String conceptName = link.getToConcept();
        if (conceptName.equals("nil") || conceptName.equals("self")) {
            SortedComboBoxModel model = (SortedComboBoxModel)comboBox.getModel();
            model.clear();
            model.addElement((Object)conceptName);
        } else {
            try {
                Concept c = (Concept)Worker.post((Task)new Task(){

                    public Object run() throws Exception {
                        return LinkSelectionPanel.this.annotationPersistenceService.findConceptByName(link.getToConcept());
                    }
                });
                comboBox.setConcept(c);
                conceptName = c.getPrimaryConceptName().getName();
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                comboBox.addItem(conceptName);
            }
        }
        comboBox.setSelectedItem(conceptName);
        waitIndicator.dispose();
        this.repaint();
    }

    public void setLinks(Collection<ILink> links) {
        JComboBox comboBox = this.getLinksComboBox();
        SearchableComboBoxModel model = (SearchableComboBoxModel)comboBox.getModel();
        model.clear();
        model.addAll(links);
        if (!model.contains((Object)this.DEFAULT_LINK)) {
            model.addElement((Object)this.DEFAULT_LINK);
        }
        comboBox.setSelectedItem(this.DEFAULT_LINK);
        this.setLink(this.DEFAULT_LINK);
        this.repaint();
    }

    public ILink getLink() {
        String linkName = this.getLinkNameTextField().getText();
        String toConcept = (String)this.getToConceptComboBox().getSelectedItem();
        String linkValue = this.getLinkValueTextField().getText();
        return new LinkBean(linkName, toConcept, linkValue);
    }
}

