/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;

public class ImageUtilities {
    public static BufferedImage watchForAndReadNewImage(File file) throws IOException, InterruptedException {
        return ImageUtilities.watchForAndReadNewImage(file, Duration.ofSeconds(3L));
    }

    public static BufferedImage watchForAndReadNewImage(File file, Duration timeout) throws IOException, InterruptedException {
        BufferedImage image = null;
        long timeoutNanos = timeout.toNanos();
        long elapsedNanos = 0L;
        long startNanos = System.nanoTime();
        while (elapsedNanos < timeoutNanos && !file.exists()) {
            Thread.sleep(50L);
            elapsedNanos = System.nanoTime() - startNanos;
        }
        if (file.exists()) {
            image = ImageIO.read(file);
        }
        return image;
    }

    public static CompletableFuture<BufferedImage> readImageAsync(File file, Duration timeout) throws IOException, InterruptedException {
        CompletableFuture<BufferedImage> future = new CompletableFuture<BufferedImage>();
        Thread thread = new Thread(() -> {
            int readAttempts = 10;
            for (int i = 0; i < readAttempts; ++i) {
                try {
                    BufferedImage bufferedImage;
                    if (i > 0) {
                        Thread.sleep(timeout.toMillis() / (long)readAttempts);
                    }
                    if ((bufferedImage = ImageUtilities.watchForAndReadNewImage(file, timeout.dividedBy(readAttempts))) == null) continue;
                    future.complete(bufferedImage);
                    break;
                }
                catch (IOException | IndexOutOfBoundsException | InterruptedException exception) {
                    // empty catch block
                }
            }
        }, ImageUtilities.class.getSimpleName() + "-" + Instant.now().toString());
        thread.start();
        return future;
    }
}

