/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Vector;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import org.mbari.swing.SortedComboBoxModel;
import org.mbari.swing.SpinningDialWaitIndicator;
import org.mbari.swing.WaitIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.AnnotationPersistenceService;
import vars.knowledgebase.Concept;
import vars.shared.ui.ConceptNameComboBox;

public class HierachicalConceptNameComboBox
extends ConceptNameComboBox {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AnnotationPersistenceService annotationPersistenceService;
    private Concept concept;

    @Inject
    public HierachicalConceptNameComboBox(AnnotationPersistenceService annotationPersistenceService) {
        this.annotationPersistenceService = annotationPersistenceService;
        this.initialize();
    }

    public HierachicalConceptNameComboBox(Concept concept, AnnotationPersistenceService annotationPersistenceService) {
        this.annotationPersistenceService = annotationPersistenceService;
        this.initialize();
        this.setConcept(concept);
    }

    public Concept getConcept() {
        return this.concept;
    }

    protected void initialize() {
        this.setEditable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (HierachicalConceptNameComboBox.this.isPopupVisible()) {
                    return;
                }
                HierachicalConceptNameComboBox.this.showPopup();
            }
        });
        this.setMaximumRowCount(12);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                HierachicalConceptNameComboBox.this.getEditor().selectAll();
            }
        });
    }

    public void setConcept(final Concept concept) {
        this.concept = concept;
        this.removeAllItems();
        if (concept != null) {
            String primaryName = concept.getPrimaryConceptName().getName();
            final SortedComboBoxModel model = (SortedComboBoxModel)this.getModel();
            model.addElement((Object)primaryName);
            SpinningDialWaitIndicator waitIndicator = new SpinningDialWaitIndicator((JComponent)((Object)this));
            SwingWorker<Collection<String>, Void> worker = new SwingWorker<Collection<String>, Void>((WaitIndicator)waitIndicator, primaryName){
                final /* synthetic */ WaitIndicator val$waitIndicator;
                final /* synthetic */ String val$primaryName;
                {
                    this.val$waitIndicator = waitIndicator;
                    this.val$primaryName = string;
                }

                @Override
                protected Collection<String> doInBackground() throws Exception {
                    HierachicalConceptNameComboBox.this.log.info("WOOT!");
                    return HierachicalConceptNameComboBox.this.annotationPersistenceService.findDescendantNamesFor(concept);
                }

                @Override
                protected void done() {
                    try {
                        model.setItems(new Vector((Collection)this.get()));
                    }
                    catch (Exception e) {
                        HierachicalConceptNameComboBox.this.log.warn("Failed to lookup " + concept, (Throwable)e);
                    }
                    finally {
                        this.val$waitIndicator.dispose();
                    }
                    if (!model.contains((Object)this.val$primaryName)) {
                        model.addElement((Object)this.val$primaryName);
                    }
                }
            };
            worker.execute();
        }
    }
}

