/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui;

import java.awt.Frame;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventTopicSubscriber;
import vars.UserAccount;
import vars.shared.ui.event.LoggingTopicSubscriber;

public class GlobalStateLookup {
    public static final String TOPIC_NONFATAL_ERROR = "vars.shared.ui.GlobalLookup-TopicNonfatalError";
    public static final String TOPIC_FATAL_ERROR = "vars.shared.ui.GlobalLookup-TopicFatalError";
    public static final String TOPIC_WARNING = "vars.shared.ui.GlobalLookup-TopicWarning";
    public static final String TOPIC_USERACCOUNT = "vars.shared.ui.GlobalLookup-UserAccount";
    public static final String TOPIC_EXIT = "vars.shared.ui.GlobalLookup-Exit";
    public static final ObjectProperty<Frame> selectedFrame;
    private static final ObjectProperty<UserAccount> userAccount;
    private static final EventTopicSubscriber<UserAccount> userAccountSubscriber;
    private static File settingsDirectory;
    public static final EventTopicSubscriber LOGGING_SUBSCRIBER;

    public static DateFormat getUTCDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    public static Frame getSelectedFrame() {
        return (Frame)selectedFrame.get();
    }

    public static ObjectProperty<Frame> selectedFrameProperty() {
        return selectedFrame;
    }

    public static void setSelectedFrame(Frame selectedFrame) {
        GlobalStateLookup.selectedFrame.set((Object)selectedFrame);
    }

    public static UserAccount getUserAccount() {
        return (UserAccount)userAccount.get();
    }

    public static ObjectProperty<UserAccount> userAccountProperty() {
        return userAccount;
    }

    public static void setUserAccount(UserAccount userAccount) {
        GlobalStateLookup.userAccount.set((Object)userAccount);
    }

    public static File getSettingsDirectory() {
        return settingsDirectory;
    }

    static {
        File logDirectory;
        selectedFrame = new SimpleObjectProperty();
        GlobalStateLookup.userAccount = new SimpleObjectProperty();
        userAccountSubscriber = (s, userAccount) -> GlobalStateLookup.setUserAccount(userAccount);
        LOGGING_SUBSCRIBER = new LoggingTopicSubscriber();
        EventBus.subscribe((String)TOPIC_USERACCOUNT, userAccountSubscriber);
        String home = System.getProperty("user.home");
        settingsDirectory = new File(home, ".vars");
        if (!settingsDirectory.exists()) {
            settingsDirectory.mkdir();
        }
        if (!(logDirectory = new File(settingsDirectory, "logs")).exists()) {
            logDirectory.mkdir();
        }
        EventBus.subscribe((String)TOPIC_EXIT, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_USERACCOUNT, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_FATAL_ERROR, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_WARNING, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_NONFATAL_ERROR, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
    }
}

